/******************************************************************************
  anf_elt_dump.c                                                           
******************************************************************************/

#include <stdio.h>
#include "kant.h"
#include "anf.h"

 
#define cnt(h) block_ref_count(h)
#define prnt   for(_i=callcnt;_i;printf("     "),_i--); printf
 
void
anf_elt_dump WITH_2_ARGS(
        order,          ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:
 
       The algebraic number alpha is written. Also all handles and
       reference counts are printed.
 
 
Calling sequence:
 
	anf_elt_dump(ord, alpha);
 
      	order       ord   = t_handle of order
      	anf_elt     alpha = algebraic number to dump
      
 
History:
 
	92-03-26 JS    first version
 
*******************************************************************************/
{
	
	order		ordcoef;
        int             _i,i, count;
        integer_big     den;
        t_handle          ah;
 
        static int      callcnt= -1;

        callcnt++;    
      
        prnt("Start anf_elt_dump of "); anf_elt_write(ord, alpha); 
        if (anf_elt_is_single(alpha))
        {
                prnt("    (Immediate integer)");
        }
        else if (anf_elt_is_con(alpha))
        {
                prnt("Handles and reference counts of conjugates:");    
                for (i=1; i<=order_rel_degree(ord); i++)
                        printf(" (%d %d) ",anf_con(alpha, i), cnt(anf_con(alpha,i)));
        }
        else 
        {                   
                ah = anf_elt_big_to_handle(alpha);
                prnt("    Handle: %d  Ref-Count: %d",ah, cnt(ah));
                if (anf_elt_is_integer(alpha))
                {
                        prnt("    (This is an integer_big)");
                }
                else
                {        
                        ordcoef = order_coef_order(ord);
                        den = anf_elt_den(alpha);
                        printf("\n");
                        for (i=1; i<=order_rel_degree(ord); i++)
                        {
                                prnt("Coefficient %d:\n",i);
                                anf_elt_dump(ordcoef, anf_elt_coef(alpha, i));
                        }
                        if (integer_is_single(den))
                        {
		                prnt("Denominator is immediate integer.");
                        }
                        else
                        {
		                ah = anf_elt_big_to_handle(den);
                                prnt("Denominator has t_handle: %d  and Ref-Count: %d",ah, cnt(ah));
                        }
                }
        }
        printf("\n");
        callcnt--;

        return;
 
}
