#include "kant.h"
#include "anf.h"
#include "real.e"
#include "ring.h"

void
anf_elt_delete_hard WITH_2_ARGS(
	t_handle,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
anf_elt_delete_hard.c
 
MB/JS August 1991
Last modification: 08.10.91
 
Deleting an algebraic number (anf_elt must not be an integer)
This routine should not be called by the user, please take the
macro anf_elt_delete which takes care of alpha being an integer.
 
*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg;
	order		ordcoef;
	integer_small	i;

/*
    Are there any other references to alpha?
    If not, we can decrement the reference counters of the denominator and
    all coefficients
*/
       
	if (!anf_elt_has_other_refs(alpha))
	{
              	deg = order_rel_degree(ord);
		if(!anf_elt_is_con(alpha))
		{
	                ordcoef = order_coef_order(ord);
 
			integer_delref(anf_elt_den(alpha));
 
			if (ring_type(ordcoef) == RING_Z)
			{
				for(i=1; i<=deg; ++i)
					integer_delref(anf_elt_coef(alpha, i));
			}
			else
			{
				for(i=1; i<=deg; ++i)
				anf_elt_delete(ordcoef, &anf_elt_coef(alpha,i));
			}
		}
		else
		{
			for(i=1; i<=deg; ++i)
				real_delete(&anf_con(alpha, i));
		}
	}
 
/*
    Decrement the reference counter of alpha (which is a disguised t_handle)
*/ 

	block_decref_delete(anf_elt_big_to_handle(alpha));
 
	return;
}
