/******************************************************************************
  anf_delete.c                                                           
******************************************************************************/
#include "kant.h"
#include "anf.h"
#include "faclst.e" 
#include "faclst.h"

void
anf_delete WITH_1_ARG(
        anf*,	a
)
/*******************************************************************************
 
Description:

	Deletes an algebraic number field.
	The field is delreffed. If there are no other references
	it is deleted completely.
                        
 
Calling sequence:

	anf_delete(&a)

	anf*	a 	= algebraic number field to be deleted
 
History:
       
        92-05-07 MD     deletion of the factorisation of (red.) disc
        92-04-01 JS	correct dyn_arr_delete at two places
        92-03-12 JS	dyn_arr_delete(&anf_poly_z_zeroes(*a, i));
	92-03-06 KW	minor changes
	91-12-10 KW	minor changes
	91-11-?? KW	written
 
*******************************************************************************/
{
        block_declarations;         
        


        faclst          fac;              
        integer_small   i,j;
	t_handle 	pring;
                
        if (block_has_other_refs(*a))
        {
                block_decref_delete(*a);
        }
        else
        {
		ring_biff_cache_blocks(*a);
		/* deleting array of minimal polynomials over Z */

                for(i=1;i<=anf_poly_z_count(*a);i++)
                {
			m_poly_z_delref(structure_pring_z, anf_poly_z_poly(*a,i));

			if (anf_poly_z_zeroes_known(*a,i))
			{
				for(j=1;j<=anf_abs_degree(*a);j++)
				{
					real_delete(&anf_poly_z_zero(*a,i,j));
				}
				ring_delete(&anf_poly_z_zeroes_reals(*a,i));
                                dyn_arr_delete(&anf_poly_z_zeroes(*a, i));
			}
                         
			integer_delref(anf_poly_z_disc(*a,i));
                        fac = anf_poly_z_disc_fac (*a,i); 
                        if (fac != MEM_NH) faclst_delete (&fac);

			integer_delref(anf_poly_z_rdisc(*a,i));
                        fac = anf_poly_z_rdisc_fac (*a,i); 
                        if (fac != MEM_NH)  faclst_delete (&fac);
                }
                if (anf_poly_z_count(*a)) dyn_arr_delete(&anf_polys_z(*a));


		/* deleting array of minimal polynomials over any orders */

                for (i=1;i<=anf_poly_order_count(*a);i++)
                {
			pring = poly_str_create(anf_poly_order_order(*a,i),1);
                        poly_elt_delete(pring,&anf_poly_order_poly(*a,i));
			poly_str_delete(0, &pring);
                        ring_delete(&anf_poly_order_poly(*a,i));
                }
                if (anf_polys_order(*a)) dyn_arr_delete(&anf_polys_order(*a));


		/* deleting array of orders */

                for (i=1;i<=anf_order_count(*a);i++)
                {
                        if (anf_order(*a,i) != MEM_NH)
                        {
                                order_anf(anf_order(*a,i)) = MEM_NH;
                                ring_delete(&anf_order(*a,i));
                        }
                }
                if (anf_order_info(*a)) dyn_arr_delete(&anf_order_info(*a));

    
		structure_parent_delete( *a );
                structure_remove( *a );
                mem_delete_hptr(a);

        }
}
