/******************************************************************************
  anf_con_elt.c                                                           
******************************************************************************/
 
#include "kant.h"
#include "mat.h"
#include "real.e"
#include "anf.h"
#include "conv.e"

anf_elt
anf_con_elt WITH_2_ARGS(
	order,		ord,
	anf_elt,	alphac
)
/*******************************************************************************

Description: 

	Computes the ccoefficients of an algebraic number if it is given via
        conjugates. This routine does not care for precision. It rounds
        without checking the result.
  
Calling sequence: 
	
	alpha = anf_con_elt(ord, alphac);
                               
	order		ord    = t_handle to the order 
	anf_elt		alphac = t_handle to conjugates of alpha
	anf_elt		alpha  = t_handle to algebraic number
 
History:

	92-03-31 JS 	first version
  
*******************************************************************************/
{
	block_declarations;
 
	anf_elt		alpha;
	order		ordcoef;
	integer_small	deg;
	integer_small	i, j, r1, r2, r12;
	t_handle		reals;
	t_real		ra, ra2, sq2, zero, rden;
	matrix		mata, matprod;
	matrix		mat;
 
        if (!anf_elt_is_con(alpha)) return anf_elt_incref(alphac);

	order_must_be_over_z(ord);
 
	ordcoef = order_coef_order(ord);
	deg     = order_abs_degree(ord);
	reals   = order_reals(ord);
 
/*
    Multiplication of the inverse of the real basis by the
    conjugate vector
*/      
	mata = mat_new(deg, 1); 
	anf_elt_to_mat_order_col(ord, alphac, mata, 1);
 
	matprod = mat_real_mat_z_mult(reals,order_basis_real_inv(ord),mata);
 
/*
    allocating alpha, casting coefficients without checking for anything 
*/
  
	anf_elt_alloc(alpha, deg);
        anf_elt_den(alpha) = 1;
 
        for (i=1; i<=deg; ++i)
        {
                anf_elt_coef(alpha, i) = 
		conv_real_to_int_round(reals, mat_elt(matprod, i, 1));
        }
 
	mat_delref(ordcoef, &mata);
	mat_delref(reals,   &matprod);
 
	return alpha;
}
