
'                        ****************
' Utility for full screen display of Tyhpoon Performance and Voice/Group parms
'                       **********************


DECLARE FUNCTION fetch.file$ (what$)
DECLARE SUB do.color (a$)
COMMON SHARED scale$, what$, lastr%

ON ERROR GOTO 30000

scale$ = " CC# DEb E FF# GAb ABb B"

CONST key$ = "Inv *4Inv *2InvertInv1/2Inv1/4Fixed 1/4   1/2   Normal*2    *4    "
CONST mode$ = "Norm  1-ShotGlide Releas"
CONST OutPut$ = "None  Left  Right Mono  Stereo"
CONST Out$ = "Any   Left  Right Mono  StereoIndie "
CONST dest$ = "Pitch VolumeFilterPan   AttackAEG/T Glide LFO1/ALFO2/ALFO1/RLFO2/RENV1  ENV2  "
CONST source$ = "Vel   Vel/R Key   Key/R Wheel Pbend PB/H  Xctl1 Xctl2 Press ExtrenLFO1  LFO2  ENV1  ENV2  "
CONST Shape$ = "TriangSaw   SquareSine  Noise "
CONST Sync$ = "None  Reset Group Voice "
CONST Priority$ = "Low   Mid   High  "

DIM parm%(64), grop%(250)
CONST white% = 15, blue% = 1, margin% = 57

' GOSUB init   ' init midi output

' vvv *** stuff for directory "fetch.file&()" *** vvvvvvv '*
'*                                                        '*
'*******************************************************  '*
     DEF fnletter% (z%) = ((z% >= 65) AND (z% <= 90)) OR -((z% >= 97) AND (z% <= 122))
'*******************************************************  '*
     DEF fncap$ (w$) = CHR$(ASC(w$ + " ") + (fnletter%(ASC(w$ + " ")) = 1) * 32)
'*******************************************************  '*
     DEF fnINPUT$ (q$)                                    '*
       PRINT q$; " ";                                     '*
       q$ = "": lc% = POS(0)                              '*
wi:                                                       '*
     k$ = ""                                              '*
     WHILE k$ = "": k$ = INKEY$: WEND                     '*
                                                          '*
                                                          '*
      IF k$ = CHR$(13) THEN GOTO qi                       '*
      IF k$ = CHR$(8) AND LEN(q$) > 0 THEN q$ = LEFT$(q$, LEN(q$) - 1)
      k% = ASC(k$)                                        '*
      IF fnletter%(k%) OR (k% >= &H20 AND k% <= &H3A) THEN q$ = q$ + k$
                           ' " "               ":"        '*
      LOCATE , lc%, 1: PRINT q$; " "; : LOCATE , POS(0) - 1, 1
    GOTO wi                                               '*
qi: fnINPUT$ = q$: PRINT                                  '*
END DEF                                                   '*
'*******************************************************  '*
DEF fnget.name$ (x%, y%)                                  '*
                                                          '*
IF lastr% THEN LOCATE lastr%, lastc%: PRINT aa$;           '*
       y% = 1 + (y% - 1) * 18: e$ = "": aa$ = ""           '*
  FOR l% = 0 TO 12                                        '*
     xx% = SCREEN(x%, y% + l%): IF xx% <> 32 AND xx% <> ASC("<") THEN e$ = e$ + CHR$(xx%)
     aa$ = aa$ + CHR$(xx%)                                  '*
  NEXT l%:                                                '*
                                                          '*
     LOCATE x%, y%: COLOR white%, blue%: PRINT aa$; : COLOR blue%, white%
     lastr% = x%: lastc% = y%                             '*
     fnget.name$ = e$                                     '*
END DEF                                                   '*
'*******************************************************  '*
DEF FnQuery% (q$)                                         '*
   PRINT q$;                                              '*
    INPUT ; y$                                            '*
   FnQuery% = fncap$(y$) = "Y"                            '*
   PRINT                                                  '*
END DEF                                                   '*
                                                          '*
   '^^^^^^********* stuff for diretory ********************^^^^


' ************ stuff for Tyhoon files: ****************


'*******************************************************
' returns note$ of scale$ ( eg  C#,  Ab ) plus octave number trimmed of extra spaces
'*******************************************************
DEF FnNote$ (t%) = RTRIM$(MID$(scale$, 2 * (t% MOD 12) + 1, 2)) + LTRIM$(STR$(t% \ 12 - 1))

'*******************************************************
' converts single byte to signed integer
'*******************************************************
DEF FnByte% (z%)
  tick% = (z% AND &H80) = &H80
  FnByte% = z% + tick% * 256
END DEF

'*******************************************************
' converts single byte to signed integer scaled to +/- 100
'*******************************************************
DEF fnt100% (z%)
  tick% = (z% AND &H80) = &H80
                           
   fnt100% = 100 * (z% + tick% * 256) \ 126

END DEF

'*******************************************************
' converts integer to scaled integer
'*******************************************************
DEF FnT200% (z%) = (105 * z%) \ 128

'*******************************************************
' converts string to long integer
'*******************************************************
DEF fnlong# (a$)
  m# = 0
   FOR l% = 1 TO LEN(a$)
    m# = m# * 256 + ASC(MID$(a$, l%, 1))
  NEXT l%
  fnlong# = m#
END DEF

'*******************************************************
' returns string n% long stripped of right spaces and padded with left spaces
'*******************************************************
DEF FnMax$ (a#, n%) = RIGHT$("     " + RTRIM$(STR$(a#)), n%)

'*******************************************************
' extracts name pointed to from string
'*******************************************************
DEF FnName$ (a$, l%) = MID$(a$, 1 + l% * 6, 6)


begin:
800
   where$ = COMMAND$
810
   COLOR blue%, white%
   GOTO perf

' ****************************************************
'         show voice
' ****************************************************

voice:
  CLOSE
  COLOR blue%, white%
 
  ' ********  get voice files *********
  what$ = "*.o??"
  e$ = fetch.file$(where$ + what$)

 IF e$ = "" GOTO fin.voice
  CLS : PRINT e$

 OPEN where$ + e$ FOR RANDOM AS #1 LEN = 4
 FIELD #1, 4 AS a$

 GET #1
  IF a$ <> "FORM" THEN RUN  ' if first wasn't FORM then not Typhoon; start again.
 GET #1
   max# = (fnlong#(a$)) \ 4  ' get total length of file (divided by 4)

 grop%(0) = &H25  ' first grop\up data starts with 25x0 byte
 t$ = "FORM" + a$
 yam% = 0

 ' ********** get whole file into t$; also get pointers to groups while at it.
 FOR ll% = 1 TO max#
  GET #1:
  t$ = t$ + a$
  IF it% THEN it% = 0: yam% = yam% + 1: PRINT "Group"; yam%, : grop%(yam%) = fnlong#(a$) + grop%(yam% - 1) + 8
  it% = (a$ = "Grop")
 NEXT ll%
  
  PRINT
  IF yam% = 1 THEN g% = 1: GOTO Gr    ' if only one group, no need to ask

grop.loop:   ' ***** ask which group to look at.
   COLOR white%, blue%

LOCATE 25, 1
PRINT "From 1 to "; yam%;
    INPUT ; "Group Number"; g%
    IF g% > yam% GOTO grop.loop
    IF g% < 1 GOTO voice

Gr:
COLOR blue%, white%
    Grop.Pointer% = grop%(g% - 1)

 IF MID$(t$, Grop.Pointer%, 4) <> "Grop" THEN GOTO fin.voice

 parm% = &H10 + Grop.Pointer%

do.Grop:
  CLS
  ' ***************** Fill parameter aray **********
  FOR l% = 0 TO 63
   parm%(l%) = ASC(MID$(t$, l% + parm%, 1))
  NEXT l%
 
  do.color (e$ + " Group" + STR$(g%) + " of" + STR$(yam%)): PRINT
     PRINT
   do.color ("Range:"): PRINT " "; FnNote$(parm%(0)); " to "; FnNote$(parm%(1));
   PRINT "  Min:"; parm%(2); "  Max:"; parm%(3)
  
   o% = FnByte%(parm%(4))

  do.color ("Pitch:"): PRINT " Oct:"; o% \ 12; "  Semi:"; o% MOD 12; "  Cnts:"; FnByte%(parm%(5));
  PRINT "  Key:"; parm%(6) + 6; ". "; FnName$(key$, parm%(6) + 5)
 
  do.color ("Volume:"): PRINT 100 - 100 * parm%(7) \ 120;
    PRINT "   Vel:"; 100 * FnByte%(parm%(8)) \ 127; "%    Max:"; parm%(9)
 
  do.color ("Filter #:")
  
   IF parm%(10) = 255 THEN
     PRINT " None"
   ELSE
     PRINT parm%(10); "D-Axis"; parm%(11); "Dyn:"; parm%(12); "Fix:"; parm%(13) * 10
   END IF

  do.color ("Output:"): PRINT parm%(18); "."; FnName$(OutPut$, parm%(18)); " Pan:"; FnByte%(parm%(19)); parm%(16); "Ind:"; parm%(20);
  PRINT "To:"; parm%(21)

  
  do.color ("AEG"):
   PRINT " At>"; 100 - fnt100%(parm%(24)); " D1>"; 100 - fnt100%(parm%(25));
   PRINT " L1>"; 100 - fnt100%(2 * parm%(22)); " D2>"; 100 - fnt100%(parm%(26));
   PRINT " L2>"; 100 - fnt100%(2 * parm%(23)); " R1>"; 100 - fnt100%(parm%(27))
 
  do.color ("Mode:"):
    IF parm%(15) THEN PRINT " Poly: On";  ELSE PRINT " Poly: Off";
     PRINT " "; FnName$(mode$, 255 AND (parm%(14) + 2));
      PRINT parm%(16) * 2560 + 10 * parm%(17) + 1; "ms"
 
  e% = 0: PRINT "LFO1:";
  GOSUB lfo

  e% = 6: PRINT "LFO2:";
  GOSUB lfo
 
  PRINT "        ";
  do.color ("L0>  T1>   L1>  T2>  L2>   T3>  L3>  Amp>"): PRINT

  e% = 0: PRINT "ENV1:";
  GOSUB env

  e% = 12: PRINT "ENV2:";
  GOSUB env
 
  Mod.pointer% = &H50 + Grop.Pointer%
 do.color ("Mod Table:"): PRINT
 ll% = 1

' ********* Show Mod Table ************
do.mod:
  a$ = MID$(t$, Mod.pointer%, 4)
  
  IF a$ <> "Mod " THEN GOTO fin.mod
  PRINT RTRIM$(STR$(ll%)); ". ";
  GOSUB Read.Mod.Table
  ll% = ll% + 1
  Mod.pointer% = Mod.pointer% + &HE
GOTO do.mod

fin.mod:
 IF a$ <> "Splt" THEN GOTO fin.voice

COLOR white%, blue%
  LOCATE 1, margin%    '  print splits in upper right corner
  PRINT "Splits at:"
  Splt.pointer% = Mod.pointer% + &H10
  LOCATE , margin%
  IF MID$(t$, Splt.pointer%, 4) = "Parm" THEN PRINT "No Wave"; : GOTO fin.voice
  ' *******  show first wave file name and where it was located
  PRINT "     "; MID$(t$, Splt.pointer%, 8); "/"; MID$(t$, 12 + Splt.pointer%, 8)
  Splt.pointer% = Splt.pointer% + &H14

do.Splt:
  a$ = MID$(t$, Splt.pointer%, 4)
  IF a$ = "Grop" THEN Grop.Pointer% = Splt.pointer%: GOTO fin.voice
  IF a$ <> "Splt" THEN GOTO fin.voice
  
  Splt.pointer% = Splt.pointer% + &H10
  LOCATE , margin%
 
  ' *******  show notename for bottom of split
  PRINT FnNote$(ASC(MID$(t$, Splt.pointer%, 1))); "  ";
 
  Splt.pointer% = Splt.pointer% + 2
  a$ = MID$(t$, Splt.pointer%, 4)
  IF a$ <> "Wave" GOTO do.Splt
  Splt.pointer% = Splt.pointer% + 8
  
  ' *******  show next wave file name / where it was located
 
  PRINT MID$(t$, Splt.pointer%, 8); "/"; MID$(t$, 12 + Splt.pointer%, 8)
 
  Splt.pointer% = Splt.pointer% + &H14
 
  GOTO do.Splt

fin.voice:

 LOCATE 25, 1: PRINT "    Enter: P)erf, V)oice, E)xit";
 IF INSTR(what$, ".o") THEN PRINT ", <- or -> or <ret> for diff group";
mish: k$ = INKEY$: IF k$ = "" THEN GOTO mish

 IF INSTR(what$, ".p") THEN GOTO no.alt

 IF ASC(k$) GOTO no.alt
 ' ***** detect left amd right arrows; inc or dec group number
 k% = ASC(RIGHT$(k$, 1)):
 IF k% = &H4D THEN
   IF g% >= yam% THEN GOTO mish
   g% = g% + 1
   GOTO Gr
   END IF
 IF k% = &H4B THEN
   IF g% < 2 THEN GOTO mish
   g% = g% - 1
   GOTO Gr
   END IF

no.alt:
  'IF k$ = "x" OR k$ = "X" THEN GOSUB sendmidi
   IF k$ = "v" OR k$ = "V" THEN GOTO voice
   IF k$ = "p" OR k$ = "P" THEN GOTO perf
   IF k$ = "e" OR k$ = "E" THEN SYSTEM

  IF INSTR(what$, ".o") THEN GOTO grop.loop
  GOTO begin

 DEF FnGet$ (p$, l%) = MID$(p$, l%, 4)
 DEF FnTrans% (p$, l%) = ASC(MID$(p$, l%, 1))

' ****************************************************
'         show performance
' ****************************************************

perf:
  do.color ("")
  what$ = "*.p??"
  e$ = fetch.file$(where$ + what$)
  CLOSE
  IF e$ = "" GOTO fin.voice
  CLS

  OPEN where$ + e$ FOR RANDOM AS #1 LEN = 4
   FIELD #1, 4 AS a$
   GET #1
   IF a$ <> "FORM" THEN RUN

 GET #1
 p$ = "FORM" + a$
 max# = fnlong#(a$)
FOR l% = 1 TO max# \ 4
  GET #1: p$ = p$ + a$
NEXT l%

  p.pointer% = &H25
  do.color (e$): PRINT
  p.pointer% = p.pointer% + fnlong#(MID$(p$, &H29, 4)) + 8
 
voice.loop:
  a$ = MID$(p$, p.pointer%, 4)
  IF a$ <> "Entr" THEN GOTO fn.voice

do.entr:
  p.pointer% = p.pointer% + 16

PRINT

do.color ("Chan:")
   o% = FnTrans%(p$, p.pointer%) + 1
   IF o% = 256 THEN PRINT " Any ";  ELSE PRINT " "; o%;

do.color ("Vol:")
   PRINT 100 - (100 * FnTrans%(p$, p.pointer% + 1)) \ 127;

do.color ("Trans:")
   o% = FnByte%(FnTrans%(p$, p.pointer% + 4))
   PRINT " Oct:"; o% \ 12; "Semi:"; o% MOD 12; "Cnts:";
   PRINT FnByte%(FnTrans%(p$, p.pointer% + 5));

do.color ("Range:")
   PRINT FnNote$(FnTrans%(p$, p.pointer% + 2));
   PRINT " to"; FnNote$(FnTrans%(p$, p.pointer% + 3)); " "

do.color ("Priority:")
  PRINT " "; FnName$(Priority, FnTrans%(p$, p.pointer% + 10) - 1);

do.color ("Output:")
  o% = FnTrans%(p$, p.pointer% + 6)
  PRINT " "; FnName$(Out$, o%);
  IF o% = 4 THEN PRINT FnByte%(FnTrans%(p$, p.pointer% + 7));
  IF o% = 5 THEN
   PRINT FnByte%(FnTrans%(p$, p.pointer% + 7)); " to";
   PRINT FnByte%(FnTrans%(p$, p.pointer% + 8));
  END IF

  p.pointer% = p.pointer% + 12

Check.It:
  IF CSRLIN < 21 THEN GOTO onward
  y% = CSRLIN: x% = POS(0)
  LOCATE 25, 1
  INPUT ; " <ret> for MORE", q%' control scrolling screen
  LOCATE y%, x%
onward:
  a$ = FnGet$(p$, p.pointer%)

  IF a$ = "Entr" GOTO do.entr
  IF a$ = "PChg" GOTO do.PChg
  IF a$ <> "Voic" THEN GOTO fn.voice

   p.pointer% = p.pointer% + 8
 GOSUB show.voc
   p.pointer% = p.pointer% + 8 + 12

 GOTO voice.loop

fn.voice:

  CLOSE :
 GOTO fin.voice

do.PChg:

   PRINT "Change: "; HEX$(FnTrans%(p$, 16 + p.pointer%)); " ";
    p.pointer% = p.pointer% + 26
     GOSUB show.voc.1
    p.pointer% = p.pointer% + &H14

GOTO Check.It



show.parms:
 FOR l% = 1 TO 4
  PRINT HEX$(ASC(MID$(a$, l%, 1))),
 NEXT l%
RETURN

Read.Mod.Table:

 l% = 8 + Mod.pointer%
 d% = ASC(MID$(t$, l% + 1, 1))

  PRINT FnName$(source$, ASC(MID$(t$, l%, 1))); "to ";
  PRINT FnName$(dest$, d%);
 LOCATE , 23
    mm% = ASC(MID$(t$, 2 + l%, 1))
    h% = CVI(MID$(t$, 5 + l%, 1) + MID$(t$, 4 + l%, 1))
  
    IF d% = 0 THEN
     PRINT "Sm>"; ASC(MID$(t$, l% + 4, 1)); "Cnt>"; ASC(MID$(t$, l% + 5, 1));
     GOTO smitty
    END IF

    PRINT "Amount:"; h%;
smitty:
LOCATE , 39
    IF mm% THEN PRINT " Frz On" ELSE PRINT " Frz Off"
RETURN

env:

  PRINT FnMax$(fnt100%(parm%(40 + e%)), 5);
  PRINT FnMax$(parm%(44 + e%) * 210 + FnT200%(parm%(45 + e%)), 6);

  PRINT FnMax$(fnt100%(parm%(41 + e%)), 5);
  PRINT FnMax$(parm%(46 + e%) * 210 + FnT200%(parm%(47 + e%)), 6);

  PRINT FnMax$(fnt100%(parm%(42 + e%)), 5);
  PRINT FnMax$(parm%(48 + e%) * 210 + FnT200%(parm%(49 + e%)), 6);

  PRINT FnMax$(fnt100%(parm%(43 + e%)), 5);
  PRINT FnMax$(fnt100%(parm%(50 + e%)), 5)

RETURN

lfo:

 PRINT parm%(28 + e%) + 1; LEFT$(FnName$(Shape$, parm%(28 + e%)), 3);
  PRINT " Rate:"; FnMax$((parm%(32 + e%) * 249 + parm%(33 + e%)) \ 2, 5);
   PRINT " Amp:"; FnMax$(100 * parm%(29 + e%) \ 127, 3);
    m% = parm%(30 + e%)
    IF m% = &HFF THEN m% = 0 ELSE m% = m% + 1
    PRINT "  Sync:"; m% + 1; FnName$(Sync$, m%);
     PRINT "Pos:"; 50 * parm%(31 + e%) \ 129;
PRINT
RETURN

show.voc:
  do.color ("Voice:")
show.voc.1:
  voice$ = MID$(p$, p.pointer%, 8)
  PRINT " "; voice$; "/";
  voice$ = MID$(p$, p.pointer% + 12, 8)
  PRINT voice$
RETURN

30000
 IF ERL = 10012 THEN RESUME fin.voice
 PRINT "Usage: 'see-typh x:' where x: is source drive for typhoon files."
 IF ERL = 800 THEN RESUME 810

SUB do.color (a$)
COLOR white%, blue%: PRINT a$; : COLOR blue%, white%
END SUB

FUNCTION fetch.file$ (what$)
lastr% = 0
bing:

10010
  rw% = 2: cl% = 1: lastr% = 0
  CLS :
10012
  b% = CSRLIN - 1: IF b% < 1 THEN b% = 1
  LOCATE b%
  FILES what$
10014
  past% = CSRLIN - 2
  LOCATE b%: PRINT SPACE$(80);

10015

bang:

  e$ = fnget.name$(rw%, cl%): LOCATE 23, 1:

  IF INSTR(what$, ".o") THEN PRINT " Voice: ";
  IF INSTR(what$, ".p") THEN PRINT " Performance: ";

  IF RIGHT$(a$, 1) = "<" THEN d$ = e$ + " <dir>     " ELSE d$ = e$ + "           "

PRINT mess$; d$;

again: k$ = INKEY$: IF k$ = "" THEN GOTO again
IF k$ <> CHR$(13) THEN GOTO psson

IF RIGHT$(a$, 1) = "<" THEN CHDIR e$: GOTO bing ELSE PRINT : fetch.file$ = e$: GOTO fin
psson:
IF fnletter%(ASC(k$)) OR k$ = "?" THEN goofy$ = k$: GOTO 10010
k% = 0: IF ASC(k$) = 0 THEN k% = ASC(MID$(k$, 2, 1))

IF k% = 75 THEN cl% = cl% - 1:
IF k% = 77 THEN cl% = cl% + 1:
IF k% = 72 THEN rw% = rw% - 1: IF rw% = b% THEN rw% = rw% - 1
IF k% = 80 THEN rw% = rw% + 1: IF rw% = b% THEN rw% = rw% + 1

IF rw% > past% THEN rw% = 2: cl% = cl% + 1: 'past%:
IF rw% < 2 THEN rw% = past%: cl% = cl% - 1'2

IF cl% < 1 THEN cl% = 1: rw% = 2
IF cl% > 4 THEN cl% = 4: rw% = past%


GOTO bang
fin:
END FUNCTION

SUB sendmidi

END SUB

