/***************************************
  $Revision: 1.11 $

  NT (Notifications) module

  Status: NOT REVIEWED, NOT TESTED

  Author(s):       Engin Gunduz

  ******************/ /******************
  Modification History:
        engin (06/07/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/


#include <stdarg.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <glib.h>
#include "UP_util.h"

typedef struct {
      GSList * less_spec; 
      GSList * exact_match;
      GSList * more_spec;
} overlap_routes;


extern int tracing;
extern int reading_from_mail;
extern int networkupdate;
/* global config variables */
extern char *mailcmd;
extern char *tmpdir;
extern char *notitxt;
extern char *fwtxt;
extern char *humailbox;
extern char *notimailtxt;
extern char *notinetworktxt;
extern char *fwmailtxt;
extern char *mtfwheader;
extern char *mtfwtxt;
extern char *query_host;
extern int query_port;
extern char *cn_subject_add;
extern char *cn_subject_del;
extern char *cn_explain_add;
extern char *cn_explain_del;
extern char *cn_overlap_add;
extern char *cn_overlap_del;
extern char *cno_subject_add;
extern char *cno_subject_del;
extern char *cno_explain_add;
extern char *cno_explain_del;
extern char *cno_overlap_add;
extern char *cno_overlap_del;  

#define ADDITION 0
#define DELETION 1

char * NT_ntfy_filename_generate( const char * tmpdir, const char * e_mail);

char * NT_forwd_filename_generate( const char * tmpdir, const char * e_mail);

char * NT_crossntfy_filename_generate( const char * tmpdir, const char * e_mail);

void NT_add_to_ntfy( char * filename, char * fmt, ... );

void NT_send_ntfy( const char * filename, const char * to_address, const char * mailercommand);

void NT_log_ntfy( const char * filename, const char * logfilename);

void NT_delete_ntfy( const char * filename);

void NT_send_ntfy_list( GHashTable * filehash, char * mailercommand);

void NT_log_ntfy_list( GHashTable * filehash, char * log_file);

void NT_delete_ntfy_list( GHashTable * filehash);

GSList * NT_gather_ntfy_addresses( const char * old_object, const char * new_object);

void NT_write_all_ntfs(char * old_object, char * new_object, char * formatted_object,
                       const char * tempdir, GHashTable * ntfy_hash,  
                       GHashTable * forwd_hash, GHashTable * cross_hash, 
                       char * from_address);

void NT_write_all_frwds(char * old_object, char * new_object, const char * tempdir,
                       GHashTable * ntfy_hash,  GHashTable * forwd_hash, GHashTable * cross_hash, 
                       const char * from_address); 

void NT_forw_create_req(const char * object);

