#       enwrite - write RIPE database entry
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: enwrite.pl,v 2.5 1998/12/09 14:39:16 roman Exp $
#
#	$RCSfile: enwrite.pl,v $
#	$Revision: 2.5 $
#	$Author: roman $
#	$Date: 1998/12/09 14:39:16 $
#
#	This routine writes a RIPE database entry to standard output
#	in long or short form.
#
#       Arguments:
#	$output		file handle for output
#	*object		pointer to assoc array with database entry
#	$long		boolean flag for long or short format output
#	$witherror	boolean flag for with or without error messages
#       $withsugar      boolean flag for with or without syntactic sugar

require "entype.pl";
require "dpr.pl";

sub enwrite {

    local($output, *object, $long, $witherrors, $withsugar) = @_;
    
    local($offset)=0;
    
    local($val);
    local(@errs)=();
    local($type)=&entype(%object);

#    &dpr("called with \$output = $output\n");
#    &dpr("\%object = ". join("*", %object) . "\n");
#    &dpr("\$long = $long, \$witherrors = $witherrors, \$withsugar = $withsugar\n");
#    &dpr("\$type = $type\n");
    
    @errs=("uw","ue") if $witherrors;

    # If not long format, and we have an unknown object, let's try
    # and print this anyway to inform the user ...

    if (!$type) {

	return 0 if (!$long);
	return 0 if (!$witherrors);

        &fatalerror("enwrite(1): cannot write. code: $!") if ( ! print $output "\n");

    
        $offset=tell($output);

	foreach $key (keys %object) {
	    
	    next if (grep(/^$key$/,@errs));
	    
	    foreach $val (split(/\n/, $object{$key})) {

	       if (($long) && ($ATTL{$key})) {
	          $key=$ATTL{$key};
	       }
	       elsif ((length($key)==2) && ($ATTR{$key})) {
	          $key="*".$key;
	       }
	       
               &fatalerror("enwrite(2): cannot write. code: $!") if ( ! printf $output "%-15s %s\n", $key.":", $val );
	       
	    }
	
	}
	
        &fatalerror("enwrite(3): cannot write. code: $!") if ( ! printf $output "%-15s %s\n", $ATTL{"ue"}.":", "Unknown object type" );
	
	return $offset;
    
    }

    if ($object{$type}) {

       &fatalerror("enwrite(4): cannot write. code: $!") if ( ! print $output "\n"); 
    
       $offset=tell($output);
	    
    }

    # print STDERR $OBJATSQ{$type}, %object,"\n";

    foreach $key (split(/ /, $OBJATSQ{$type}), @errs) {
    
        # print STDERR "*",$key,"* ", $object{$key}, "\n";
    
	if ($object{$key}) {
           
           # print STDERR $key, "\n";

	    foreach $val (split(/\n/, $object{$key})) {

		if ($long) {

		    # HARDCODED SYNTACTIC SUGAR !!!!

		    if ($withsugar) {
			
			local($M) = "\\S+\\s+\\S+\\s+\\S+";
			
			if ($key eq "ae") {
			    $val=~ s/^(AS\d+)/exclude $1 to/;
			}
			elsif ($key eq "ai") {
			    $val=~ s/^(AS\d+\s+\d+)/from $1 accept/;
			}
			elsif ($key eq "ao") {
			    $val=~ s/^(AS\d+)(\s+)/to $1 announce$2/;
			}
			elsif ($key eq "it") {
			    $val=~ s/^($M)\s+(\(\s*pref[=\s\S]+\))/from $1 $2 accept/ ||
			    $val=~ s/^($M)\s+/from $1 accept /;
			}
			elsif ($key eq "io") {
			    $val=~ s/^($M)\s+(\(\s*metric\-out[=\s\S]+\))/to $1 $2 announce/ ||
			    $val=~ s/^($M)\s+/to $1 announce /;
			}
		    }

		    # END HARDCODED

                    &fatalerror("enwrite(5): cannot write. code: $!") if ( ! printf $output "%-12s %s\n", $ATTL{$key}.":", $val );

		}
		else {
                    &fatalerror("enwrite(6): cannot write. code: $!") if ( ! print $output "*", $key, ": ", $val, "\n" );
		}
	    }
	}
    }

    return $offset;
    
}

1;
