# cryptpw.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997, 1998, 1999 by RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: cryptpw.pl,v 2.3 1998/07/15 18:01:23 joao Exp $
#
#	$RCSfile: cryptpw.pl,v $
#	$Revision: 2.3 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:23 $

#
# cryptpw encrypts a password for use in the
# CRYPT-PW field in the 'mntner' objects
#
# Usage:
#
# cryptpw PasswordString SaltString
#

if ((scalar(@ARGV) == 2) && ($ARGV[0]) && ($ARGV[1])) {
   
   local($password)=$ARGV[0];
   local($salt)=$ARGV[1];

   local($cryptpw)=crypt($password,$salt);

   print "Crypted password: ", $cryptpw, "\n";

   # for debugging ;-):
   #
   #if ( crypt($password, $cryptpw) eq $cryptpw ) {
   #   print "match\n";
   #}
   #else { 
   #   print "no match \n";
   #}
   
}
else {

   print STDERR "Error in arguments list:\n" if (@ARGV);
   
   print STDERR "\nUsage:\n\n$0 PasswordString SaltString\n\n";
   
   exit 1 if (@ARGV);
   
}

