/***************************************
  $Revision: 1.1 $

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (10/04/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#ifndef _NH_H
#define _NH_H

#include <mysql_driver.h>

#define MAX_NH_LENGTH  64
#define MAX_NH_SPACE_LENGTH 5
#define MAX_NH_SOURCE_LENGTH 10

#define MAX_NIC_ID  99999
#define NULL_NIC_ID (MAX_NIC_ID+1)
#define AUTO_NIC_ID (MAX_NIC_ID+2)
#define MAX_RANGE   NULL_NIC_ID
#define MIN_RANGE   0
 
typedef struct _range_t {
  long start;
  long end;
  char *space;
  char *source;
} range_t;

/* structure to save nic handle data */
typedef struct _nic_handle_t {
  long nic_id;
  char *space;
  char *source;
} nic_handle_t;

int NH_check(nic_handle_t *pnh, SQ_connection_t *sql_connection);
int NH_free(nic_handle_t *pnh, SQ_connection_t *sql_connection);
int NH_register(nic_handle_t *pnh, SQ_connection_t *sql_connection);

int NH_convert(char *nic, nic_handle_t *pnh);
int NH_parse(char *nic, nic_handle_t **pnh);

void free_nh(nic_handle_t *nh_ptr);

#endif /* _NH_H */
