/***************************************
  $Revision: 1.4 $

  Utilities (ut). memwrap.c - memory allocation wrappers. 
                              Facilitate easy changing a memory allocation
			      library and provide uniform error codes.

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#include <stdlib.h>
#include <erroutines.h>
#include <stubs.h>

static void
wr_alloc_log(void *ptr, int len, char* comment, int line) 
{
  /* fprintf(stderr,"allocated %7d bytes at address %p in %s/%d\n",
	  len, ptr, comment, line);
  */
}

static void
wr_free_log(void *ptr, char* comment, int line) 
{
  /*
  fprintf(stderr,"freed some memory space at address %p in %s/%d\n", ptr, comment, line);
  */
}



er_ret_t 
wr_real_malloc(void **ptr, size_t size, char* comment, int line) 
{
  if( (*ptr = malloc(size)) == NULL ) {
    /* die; */ /* this should return an appropriate error number */
    return UT_OUTMEM;
  }
  else {
    wr_alloc_log(*ptr, size, comment, line);
    return UT_OK;
  }
}

er_ret_t 
wr_real_calloc(void **ptr, size_t num, size_t size, char* comment, int line) 
{
void *newalloc;

  newalloc = calloc(num, size);

  if( newalloc == NULL ) {
    /*die; */ /* this should return an appropriate error number */
    return UT_OUTMEM;
  }
  else {
    *ptr=newalloc;
    wr_alloc_log(*ptr, size*num, comment, line);
    return UT_OK;
  }
}


er_ret_t  
wr_real_realloc(void **ptr, void *oldptr, size_t size, char* comment, int line) 
{
  if( (*ptr = realloc(oldptr, size)) == NULL ) {
    /* die;  */ /* this should return an appropriate error number */
   return UT_OUTMEM;
  } 
  else {
    wr_alloc_log(*ptr, size, comment, line);
    return UT_OK;
  }
}

er_ret_t 
wr_real_free(void *ptr, char* comment, int line) 
{
  if( ptr == NULL ) {
    die;
  }
  wr_free_log(ptr, comment, line);
  free(ptr);
  /* if we're tired of those dies, we can set the pointer to NULL after free */
  return UT_OK;
}


