#ifndef READ_THREAD
#define READ_THREAD

/***************************************
  $Revision: 1.8 $

  Thread module (th)

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <pthread.h>       /* Posix thread library */

typedef struct _rwlock {
  pthread_mutex_t rw_mutex;
  pthread_cond_t rw_cond;
  int rw_count;
} rw_lock_t;


void TH_acquire_read_lock(rw_lock_t *prw_lock);
void TH_release_read_lock(rw_lock_t *prw_lock);
void TH_acquire_write_lock(rw_lock_t *prw_lock);
void TH_release_write_lock(rw_lock_t *prw_lock);
void TH_init_read_write_lock(rw_lock_t *prw_lock);
void TH_do_whois(void *arg);
void TH_do_config(void *arg);
void TH_hdl_signal(void);
int TH_get_id(void);
char *TH_to_string(void);
void TH_run(int sock, void *do_function(void *));
void TH_run1(int sock, void *do_function(void *));
void TH_run2(void *function(void *));

#endif /* READ_THREAD */
