#ifndef READ_PROTOCOL_CONFIG
#define READ_PROTOCOL_CONFIG

/***************************************
  $Revision: 1.6 $

  Protocol config module (pc).  This is the protocol that the admin uses to
  talk to the server.

  Status: NOT REVUED, NOT TESTED

  +html+ <DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+   <LI><A HREF="../src/Protocol.c">Source Code</A>
  +html+ </UL>
  +html+ </DL>
  +html+ <PRE>
  +html+ </PRE>
 
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/*+ String sizes +*/
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383

#define DEFAULT_USER_NAME "user"

/*+ Log message +*/
#define LOG_CONFIG "[%d] %s %s %s\n"

/*+ Maximum size of input that can be recieved from the client. +*/
#define MAX_INPUT_SIZE  1024

/*+ This propmt is sent to the user. +*/
/*
#define PROMPT  "\nwhois R.I.P. config> "
#define PROMPT  "\nwhois \033[0;1;33;40mR.I.P.\033[0m config> "
*/

/*+ This login propmt is sent to the user. +*/
#define LOGIN_PROMPT  "\nlogin: "

/*+ This password propmt is sent to the user. +*/
#define PASSWD_PROMPT  "password: "

/* XXX Why doesn't invisible work ???!?!?!

http://www.dee.ufpb.br/~bob/tools/ansi.html
http://cs.wwc.edu/~bellmi/ANSI_escape_codes.html

#define ECHO_ON "\033[8m"
*/

/* Use reverse video instead - grrr. */
#define ECHO_ON "\033[33;43m"

#define ECHO_OFF "\033[0m"

#define CLEAR_SCREEN "\033[2J"

/*+ This welcome message is sent to the user, upon connecting. +*/
/*
#define WELCOME  "Welcome to the whois R.I.P. server.\n"
*/

#define HELP_ERROR        "Invalid help command: "
#define HELP_HELP         "Print help information."
#define HELP_QUIT         "Quit the server."
#define HELP_SHOW         "Show the values of: (type show for a list)"
#define HELP_REPEAT       "Repeat a command n times."
#define HELP_SHOW_ERROR   "Invalid show command: "
#define HELP_SHOW_CONST   "The values of a constant used in the server."
#define HELP_SHOW_CONSTS  "The values of constants used in the server.\n(This is set from values in properties object.)"
#define HELP_SHOW_PROPS   "The values of properties in the properties file."
#define HELP_SHOW_THREAD  "The properties of the client's thread."
#define HELP_SHOW_WHOIS   "The values of the whois query module."
#define HELP_SHOW_ACCESS  "The access to server."
#define HELP_SHOW_ACL     "The access control list for server."
#define HELP_SET          "Set the values of: (type set for a list)"
#define HELP_SET_ERROR    "Invalid set command: "
#define HELP_SET_CONST    "Set the values of a constants: (type set const name=value)"
#define HELP_SET_CONSTS   "Set the values of constants used in the server.\n(This is set from values in properties object.)"
#define HELP_SET_PROPS    "Set the values of properties in the properties file."
#define HELP_SQL          "Issue an sql command to the database."

void PC_interact(int sock);

#endif /* READ_PROTOCOL_CONFIG */
