/***************************************
  $Revision: 1.8 $

  IP handling (ip). iproutines.h  - header file for conversions routines.
                                    defines data structures for IP module.

  Status: NOT REVUED, TESTED

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/


#ifndef _IP_H
#define _IP_H

#include <glib.h>
#include <erroutines.h>

/*+ the space type +*/
typedef enum {
  IP_V4 = 1,
  IP_V6,
} ip_space_t;  

/*+ address structure +*/
typedef struct {
  unsigned int  words[4];    /*+ 32/128 bit ip addr. SUBJECT TO CHANGE +*/
  char space; /*+ char is shorter than ip_space_t but still compatible +*/
} ip_addr_t;

/*+ prefix structure +*/
typedef struct {
  unsigned       bits;		/*+ length in bits. +*/
  ip_addr_t      ip;	        /*+ the IP of the prefix +*/        
} ip_prefix_t;
 
/*+ range structure +*/
typedef struct {
  ip_addr_t         begin;        /*+ IP where the range begins. +*/
  ip_addr_t         end;          /*+ IP where it ends +*/
} ip_range_t;

/*+ 
  stores size/span of an allocation 
  SUBJECT TO CHANGE: will be bigger for IPv6 
  +*/
typedef unsigned int  ip_rangesize_t; 

/*+  the length of a string that should be able to hold a prefix / range
    when used with b2a functions.
+*/
#define IP_ADDRSTR_MAX 20 /* XXX watch out for IPv6 !! */
#define IP_PREFSTR_MAX 24
#define IP_RANGSTR_MAX 48

/*+ 
  IP expansion mode - for use with t2b functions, they control
  whether the input is supposed to be fully expanded or contain shortcuts
  (eg. enabling saying 0/0 instead 0.0.0.0/0)
  +*/
typedef enum {
  IP_PLAIN = 1,
  IP_EXPN
} ip_exp_t;

/* prototypes */

er_ret_t IP_addr_t2b(ip_addr_t *ipptr, char *addr, ip_exp_t expf);
er_ret_t IP_pref_t2b(ip_prefix_t *prefptr, char *prefstr, ip_exp_t expf);
er_ret_t IP_rang_t2b(ip_range_t *rangptr, char *rangstr, ip_exp_t expf);

/* convenience (or call it backward compatibility) macros */

#define IP_addr_e2b(a,b) IP_addr_t2b(a,b,IP_PLAIN)
#define IP_pref_e2b(a,b) IP_pref_t2b(a,b,IP_PLAIN)
#define IP_rang_e2b(a,b) IP_rang_t2b(a,b,IP_PLAIN)

#define IP_addr_a2b(a,b) IP_addr_t2b(a,b,IP_EXPN)
#define IP_pref_a2b(a,b) IP_pref_t2b(a,b,IP_EXPN)
#define IP_rang_a2b(a,b) IP_rang_t2b(a,b,IP_EXPN)
    
er_ret_t IP_addr_b2a(ip_addr_t *binaddr, char *ascaddr, int strmax );
er_ret_t IP_pref_b2a(ip_prefix_t *prefptr, char *ascaddr, int strmax);
er_ret_t IP_rang_b2a(ip_range_t *rangptr, char *ascaddr, int strmax);
er_ret_t IP_rang_classful(ip_range_t *rangptr, ip_addr_t *addrptr);

  
int  IP_addr_bit_get(ip_addr_t *binaddr, int bitnum);
void IP_addr_bit_set(ip_addr_t *binaddr, int bitnum, int bitval);
int  IP_addr_cmp(ip_addr_t *ptra, ip_addr_t *ptrb, int len);
int  IP_sizebits(ip_space_t spc_id);
void IP_pref_bit_fix( ip_prefix_t *prefix );

er_ret_t IP_smart_conv(char *key, int justcheck, int encomp, 
		       GList **preflist, ip_exp_t expf);

ip_rangesize_t IP_rang_span( ip_range_t rangptr );
er_ret_t IP_addr_s2b(ip_addr_t *addrptr, void *addr_in, int addr_len);

/* 
   this is to define a constant struct for comparisons.
*/
#ifdef IP_IMPL
const ip_addr_t IP_ADDR_UNSPEC={{0,0,0,0},0}; /* unlikely to be real :-)
					       as there is no space 0 
					       and natural state after 
					       initializing to 0 */
#else
extern ip_addr_t IP_ADDR_UNSPEC;
#endif

#endif /* _IP_H */
