/***************************************
  $Revision: 1.5 $

  Example code: Upper case server.

  Status: NOT REVUED, NOT TESTED

  Author:       Chris Ottrey

  +html+ <DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL>
  +html+ </DL>
 
  ******************/ /******************
  Modification History:
        ottrey (09/03/1999) Created.
  ******************/ /******************
  Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
  Copyright (c) 1998                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#define DEFAULT_PROP_FILE_NAME ".properties"

#include "erroutines.h"
#include "constants.h"
#include "properties.h"
#include "server.h"
#include "bitmask.h"

void error_init(int argc, char ** argv) {
  er_path_t erlogstr;

  ER_init(argc, argv);

  erlogstr.fdes = stderr;
  erlogstr.asp  = 0;
  erlogstr.sev  = ER_SEV_W;
  erlogstr.mode = ER_M_SEVCHAR | ER_M_TEXTLONG;

  ER_setpath(& erlogstr);  

} /* error_init() */

int main(int argc, char** argv) {
  char *prop_file_name;                                              /* 1. */

  /* Initialize error handling */
  error_init(argc, argv);

  /* 1. Get the properties file name from argv[1] (Defaults to ".properties" if none specified) */
  if (argc == 2) {
    prop_file_name = (char *)calloc(1, strlen(argv[1])+1 );
    strcpy(prop_file_name,argv[1]);
  } else { 
    prop_file_name = (char *)calloc(1, strlen(DEFAULT_PROP_FILE_NAME)+1 );
    strcpy(prop_file_name, DEFAULT_PROP_FILE_NAME);
  }

  printf("Loading properties from prop_file_name=%s\n", prop_file_name);

  /* 2. Load properties object from prop_file. */
  PR_load(prop_file_name);
  printf("%s\n", PR_to_string() );

  /* 3. Set the constants. */
  CO_set();
  printf("%s\n", CO_to_string() );

  /* 4. Start the server */
  SV_start();

  return(0);

} /* main() */

