char *ImpFullCopyright = "\
Copyright 1993,1994 Globetrotter Software, Inc.\n\
\n\
Permission to use, copy, modify, distribute, and sell this software and its\n\
documentation for any purpose is hereby granted without fee, provided that\n\
the above copyright notice appear in all copies and that both that\n\
copyright notice and this permission notice appear in supporting\n\
documentation, and that the name of Globetrotter Software not be used\n\
in advertising or publicity pertaining to distribution of the software\n\
without specific, written prior permission.  Globetrotter Software makes\n\
no representations about the suitability of this software for any purpose.\n\
It is provided \"as is\" without express or implied warranty.\n\
\n\
GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,\n\
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO\n\
EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR\n\
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,\n\
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER\n\
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE\n\
OF THIS SOFTWARE.\n";
/*
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* main.c for htimp
 *
 * Jim McBeath, Nov 18, 1993
 */

#include <stdio.h>
#include "htimp.h"
#include "version.h"

int ImpDebug;
int ImpDebugReply;
int ImpDebugStayConnected;

char *ProgPath;
char *ProgName;

void
ImpUsage()
{
fprintf(stderr,"debug usage: %s [-d] [-dc] [-dr] [-s] [-v] [-copyright] [-- etc]\n",
				ProgName);
fprintf(stderr,"-d  Turn on general debugging flag\n");
fprintf(stderr,"-dc In server, stay connected to terminal\n");
fprintf(stderr,"-dr In client, print master's reply to stderr also\n");
fprintf(stderr,"-s  Start in server mode\n");
fprintf(stderr,"-v  Print version info, then exit\n");
fprintf(stderr,"-copyright   Print long copyright info, then exit\n");
fprintf(stderr,"--  Process all remaining args in non-debug mode\n");
}

void
ImpProcessDebugArgs(argc,argv,ci)
int argc;
char *argv[];
CommandInfo *ci;
{
	int i;
	int startserver=0;

	for (i=1; i<argc; i++) {
		if (strcmp(argv[i],"-cf")==0) {
			if (++i>=argc)
				ImpFatal("No arg for -cf");
				/* NOTREACHED */
			ImpSetConfFileName(argv[i]);
		}
		else if (strcmp(argv[i],"-d")==0) {
			ImpDebug = 1;
		}
		else if (strcmp(argv[i],"-dc")==0) {
			ImpDebugStayConnected = 1;
		}
		else if (strcmp(argv[i],"-dr")==0) {
			ImpDebugReply = 1;
		}
		else if (strcmp(argv[i],"-s")==0) {
			startserver=1;
		}
		else if (strcmp(argv[i],"-v")==0) {
			fprintf(stderr,"%s\n%s\n%s\n",
				ImpVersion, ImpAuthor, ImpCopyright);
			exit(0);
		}
		else if (strcmp(argv[i],"-copyright")==0) {
			fprintf(stderr,"%s\n",ImpFullCopyright);
			exit(0);
		}
		else if (strcmp(argv[i],"--")==0) {
			/* Process the rest of the arguments as if
			 * we had been run normally from the server */
			argv[i] = ProgPath;
			ImpProcessServerArgs(argc-i,argv+i,ci);
			return;
		}
		else {
			ImpUsage();
			exit(1);
		}
	}
	if (startserver) {
		/* Start the server w/o forking */
		ImpReadConfFile();  /* read our configuration file */
		ImpMasterMain();	/* run the server */
		/* NOTREACHED */
	}
}

main(argc,argv)
int argc;
char *argv[];
{
	CommandInfo ci;
	char *getenv();

	ProgPath = argv[0];
	ProgName = strrchr(ProgPath,'/');
	if (ProgName) ProgName++;
	else ProgName = ProgPath;
	if (getenv("HTIMP_DEBUG"))
		ImpDebug = 1;
	memset((char *)&ci,'\0',sizeof(ci));	/* clear it out first */
	if (strcmp(ProgName,"htimpdbg")==0) {
		/* We are running the debugging version,
		 * so look for command line options */
		ImpProcessDebugArgs(argc,argv,&ci);
	} else {
		/* Run normally, from http server, so look for info from it */
		ImpProcessServerArgs(argc,argv,&ci);
	}
	ImpReadConfFile();		/* read our configuration file */
	if (!ci.mode) {	/* might happen when using debug version */
		ImpFatal("No operation specified");
		/* NOTREACHED */
	}
	if (!ImpConnectToMaster()) {
		ImpStartMaster();
		if (!ImpConnectToMaster()) {
			ImpFatal("Can't connect to master after starting it");
			/* NOTREACHED */
		}
	}
	ImpSendCommandToMaster(&ci);
	ImpPrintReplyFromMaster();
	fflush(stdout);
	fclose(stdout);
	fclose(stderr);	/* master keeps this one open */
	exit(0);
}

/* end */
