/*
 * Copyright 1993,1994 Globetrotter Software, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Globetrotter Software not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Globetrotter Software makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO
 * EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* app.h - definitions for appplication end of things
 *
 * Jim McBeath, November 18, 1993
 */

#define DEFAULT_APP_READ_TIMEOUT 60
#define HANDLE_LENGTH 8		/* number of random chars in a handle */

typedef struct _appinfo {
	struct _appinfo *next;
	char *name;
	char *title;		/* title to use if headerstyle==HTML */
	char *subtitle;		/* subtitle (formatted) */
	char *execpath;		/* what to exec to start a job for this app */
	int killtimeout;	/* number of minutes to kill job */
	int cleanuptimeout;	/* number of additional minutes to clean up */
	int readtimeout;	/* how long to wait for app to reply */
	int formatout;		/* true means look for %X stuff in app output */
	int headerstyle;
#define HEADER_NONE 0	/* add no header info */
#define HEADER_MIME 1	/* prepend mime header info (content-type) */
#define HEADER_HTML 2	/* prepend mime header and HTML header/title/h1 */
#define HEADER_ISINDEX 3	/* HTML plus <ISINDEX> */
#define HEADER_PLAINTEXT 4	/* HTML plus <ISINDEX> and <plaintext> */
	char *lastout;
	int lastoutlen;
	int striplastout;	/* <>0 means don't pass lastout chars */
} AppInfo;

typedef struct _jobinfo {
	struct _jobinfo *next;
	AppInfo *app;
	char handle[HANDLE_LENGTH+1];
	pid_t pid;
	int stdind;	/* pipe desc we use to write to job's stdin */
	int stdoutd;	/* we read from job's stdout */
	int killed;	/* set when job has been killed */
	time_t lastcmdtime;	/* ticker value of most recent command */
	time_t killedtime;	/* ticker value of when job was killed */
	int numreads;	/* number of times we have read replies from job */
} JobInfo;

/* end */
