/*	A small List class					      HTList.c
**	==================
**
**	A list is represented as a sequence of linked nodes of type HTList.
**	The first node is a header which contains no object.
**	New nodes are inserted between the header and the rest of the list.
*/

#include "HTList.h"

HTList * HTList_new ()
{
  HTList *newList = malloc (sizeof (HTList));
  newList->object = NULL;
  newList->next = NULL;
  return newList;
}

void HTList_delete (HTList *this)
{
  HTList *current;
  while (current = this) {
    this = this->next;
    free (current);
  }
}

void HTList_addObject (HTList *this, void * newObject)
{
  if (this) {
    HTList *newNode = malloc (sizeof (HTList));
    newNode->object = newObject;
    newNode->next = this->next;
    this->next = newNode;
  }
  else
    if (TRACE) printf ("HTList: Trying to add object %p to a nonexisting list\n",
		       newObject);
}

BOOL HTList_removeObject (HTList *this, void * oldObject)
{
  if (this) {
    HTList *previous;
    while (this->next) {
      previous = this;
      this = this->next;
      if (this->object == oldObject) {
	previous->next = this->next;
	free (this);
	return YES;  /* Success */
      }
    }
  }
  return NO;  /* object not found or NULL list */
}

void * HTList_removeLastObject (HTList *this)
{
  if (this && this->next) {
    HTList *lastNode = this->next;
    void * lastObject = lastNode->object;
    this->next = lastNode->next;
    free (lastNode);
    return lastObject;
  } else  /* Empty list */
    return NULL;
}

void * HTList_removeFirstObject (HTList *this)
{
  if (this && this->next) {
    HTList * prevNode;
    void *firstObject;
    while (this->next) {
      prevNode = this;
      this = this->next;
    }
    firstObject = this->object;
    prevNode->next = NULL;
    free (this);
    return firstObject;
  } else  /* Empty list */
    return NULL;
}

int HTList_count (HTList *this)
{
  int count = 0;
  if (this)
    while (this = this->next)
      count++;
  return count;
}

int HTList_indexOf (HTList *this, void * object)
{
  if (this) {
    int position = 0;
    while (this = this->next) {
      if (this->object == object)
	return position;
      position++;
    }
  }
  return -1;  /* Object not in the list */
}

void * HTList_objectAt (HTList *this, int position)
{
  if (position < 0)
    return NULL;
  if (this) {
    while (this = this->next) {
      if (position == 0)
	return this->object;
      position--;
    }
  }
  return NULL;  /* Reached the end of the list */
}
