//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TSockView
//	Include File:	tsockvie.h
//	Purpose:	Display total amount of current network activity
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-31-94	created
//		02-10-94	Split all members into seperate files.
#include"tsockvie.h"
#include<strstrea.h>
#include<iomanip.h>

void TSockView::draw()	{
//	Purpose:	ReDraw the view to the display
//	Arguments:	none
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-31-94	created

	TDrawBuffer TDB;
	char c = getColor(2);

	//	Convert to a string.
	ostrstream totalStr(SockInAscii, sizeof(SockInAscii));
	totalStr << setw(12) << uli_pres << ends;

	//	First clear, then redraw the view
	TDB.moveChar(0, ' ', c, size.x);
	TDB.moveStr(0, SockInAscii, c);
	writeLine(0, 0, size.x, 1, TDB);
}
