//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-09-94	Split all members into seperate files.
#include"turlwind.h"

void TURLWindow::dragView(TEvent& TE_event, unsigned char uc_mode, TRect&
	TR_limits, TPoint TP_minSize, TPoint TP_maxSize)	{
//	Purpose:	Capture the resizing of a window in order to
//			correctly size the URL within.
//	Arguments:	TE_event	The event occuring causing resize.
//			uc_mode		Mode of the window.
//			TR_limits	Limits size of window
//			TP_minSize	Limits smallest size of window
//			TP_maxSize	Limits maximum size of window
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-21-94	created

	//	Need to reload the URL if window chaned x size.
	TRect oldTR = getExtent();

	//	Have the base resize.
	TWindow::dragView(TE_event, uc_mode, TR_limits, TP_minSize,
		TP_maxSize);

	TRect TR = getExtent();
	//	Reload if x size changed.
	if(oldTR.b.x != TR.b.x)	{
		//	First take out the last item in the
		//	history.  There will always be atleast
		//	one entry.  Assume the reload will always
		//	work.
		auto char *cp_oldURL = (char *)(TNSCp_visited->
			at(TNSCp_visited->getCount() - 1));

		TNSCp_visited->remove(cp_oldURL);
		TNSCp_visited->pack();
		delete(cp_oldURL);

		URLoader(TURLV->getURL());
	}
}
