#ifndef __CAPSTDIO_H
/*
 *	Avoid include redundancy
 */
#define __CAPSTDIO_H

/*
 *	Copyright (c) 1994, University of Kansas, All Rights Reserved
 *
 *	Include File:	capstdio.h
 *	Purpose:	Capture function writing to stdout, stderr, and
 *			redirect their output into a window.
 *	Remarks/Portability/Dependencies/Restrictions:
 *		All functions used to write to the streams stdout and stderr
 *		should be written here to capture the output.
 *		This header files should be included in all source using the
 *		functions that will need to be captured.
 *	Revision History:
 *		01-08-94	created
 */

/*
 *	Constant defines
 */
#include<stdio.h>
#define	fprintf	capfprintf
#define fputs	capfputs
#define fwrite	capfwrite
#define perror	capperror
#define printf	capprintf
#ifdef putc
#undef putc
#endif /* putc */
#define putc	capputc

#ifdef WATTCP
/*
 * 	We are using the wattcp libraries.
 *	Capture their assembly output functions.
 */
#define outs	capouts
#define outch	capoutch
#define outhex	capouthex
#endif /* WATTCP */

/*
 *	Required includes
 */

/*
 *	Function declarations
 */
#ifdef __cplusplus
extern "C"	{
#endif /* __cplusplus */

int capfprintf(FILE *Fp_stream, const char *cp_format, ...);
int capfputs(const char *cp_s, FILE *Fp_stream);
size_t capfwrite(const void *vp, size_t st_size, size_t st_n, FILE *Fp_stream);
void capperror(const char *cp_s);
int capprintf(const char *cp_format, ...);
int capputc(int c, FILE *Fp_stream);

/*
 *	Actually found in TCapture.cpp
 */
void cap_stdout(const char *);
void cap_stderr(const char *);

#ifdef WATTCP
void capoutch(char c);
void capouts(char *cp);
void capouthex(char c);
#endif /* WATTCP */

#ifdef __cplusplus
}
#endif /* __cplusplus */

/*
 *	Global variable declarations
 */

/*
 *	Macros
 */

#endif /* __CAPSTDIO_H */
