//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"
#include"trace.h"
#include<string.h>

void TURLView::LoadChild()	{
//	Purpose:	Cause the load of the selected child anchor.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Puts an event into the event queue such that the following
//		actions should be taken by the owner of the TURLView:
//			destroy the TURLView
//			load the child anchor in the TURLView's place.
//	Revision History:
//		01-30-94	created
//		04-06-94	Modified to not load if it is a tagged anchor
//				and we are the same document.  Will instead
//				search for the named anchor and scrollTo
//				it's position.

	//	Figure out this view's url and the selected anchor's url.
	auto char *cp_thisURL = getURL();
	auto char *cp_childURL = getChild();

	//	If the child goes nowhere, can't select.
	if(cp_childURL == NULL)	{
		return;
	}

	//	Find out if the child has a tag.
	auto char *cp_startTag;
	if((cp_startTag = strchr(cp_childURL, '#')) != NULL)	{
		//	Compare the two, if same, assume named anchor.
		if(strncmp(cp_thisURL, cp_childURL, (int)(cp_startTag -
			cp_childURL)) == 0)	{
			//	Assume it is a tag.
			//	Seek out it's location and scroll to it if
			//	possible.
#ifndef RELEASE
			trace("Tagged anchor within this document.");
#endif // RELEASE
			//	Advance past the '#'
			cp_startTag++;

			//	Go through the list of anchors comparing
			//	tags.
			auto TextAttribute *TAp_looking;
			for(auto unsigned short int usi_counter = 0U;
				usi_counter < TNSCp_anchors->getCount();
				usi_counter++)	{
				TAp_looking = (TextAttribute *)
					(TNSCp_anchors->at(usi_counter));

				//	Continue on if the tag is empty.
				if(TAp_looking->HTCAp_anchor->tag == NULL)
				{
					continue;
				}

				if(strcmp(TAp_looking->HTCAp_anchor->tag,
					cp_startTag) == 0)	{
					//	Found.
					TAp_selected = TAp_looking;
					AnchorInView();

					//	Fudge the history list of the
					//	window.
					/*	Taken out for alpha release.
					auto TEvent TE_fudge;
					TE_fudge.what = evCommand;
					TE_fudge.message.command =
						cmAddToHist;
					TE_fudge.message.infoPtr = (void *)
						cp_startTag;
					putEvent(TE_fudge);
					*/

					//	Done.
					delete(cp_childURL);
					return;
				}
			}
			//	Tag not found.  Just continue on with an
			//	attempt to load.
		}
	}

	//	Free the child url, allocated in other code by a call to
	//	getChild();
	delete(cp_childURL);

	auto TEvent TE_load;

	//	Set up the event.
	//	Make sure to somehow mark which TURLView to destory through
	//		this message.
	TE_load.what = evCommand;
	TE_load.message.command = cmLoadChild;
	TE_load.message.infoPtr = (void *)this;

	//	Output the message.
	putEvent(TE_load);
}
