//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"

Boolean TURLView::AnchorSelectXYView(signed short int ssi_x, signed short int
	ssi_y)	{
//	Purpose:	Attempt to select the anchor in view corresponding
//			to the ssi_x and ssi_y coordinates.
//	Arguments:	ssi_x	The view horizontal coordinate.
//			ssi_y	The view vertical coordinate.
//	Return Value:	Boolean	True	There was a valid anchor under the
//					specified coordinates.
//					The selected anchor has been updated.
//				False	Attempt to make an invalid selection.
//	Remarks/Portability/Dependencies/Restrictions:
//		For use with mouse.
//		Extra lines beneath the end of HText in the view will cause
//		problems.  Watch out.
//	Revision History:
//		01-30-94	created.

	//	First make sure anchors exist in the document.
	if(TNSCp_anchors->getCount() == 0)	{
		return(False);
	}

	//	If by some freak of nature, that the y coordinate will be
	//	beyond the document.  Don't let this happen.
	if(delta.y + ssi_y >= limit.y)	{
		return(False);
	}

	//	Figure out the line which the view wishes to select.
	ssi_y += delta.y;
	ssi_x += delta.x;

	//	Convert to a rendered stream offset.
	//	Beginning of line.
	auto signed long int sli_offset = (signed long int)(TNSCp_lines->
		at(ssi_y));
	//	Seek and obtain line information.
	auto Line L_mouse;
	fsp_temp->seekg(sli_offset);
	fsp_temp->read((char *)(&L_mouse), sizeof(Line));
	if(fsp_temp->gcount() != sizeof(Line))	{
		doslynxmessage("Error in reading rendered image file.");
		return(False);
	}
	//	Move past the line information.
	sli_offset += sizeof(Line);
	//	Make sure X coordinates do not go past the line data.
	if(ssi_x - L_mouse.ssi_indent > L_mouse.ssi_length)	{
		return(False);
	}
	//	Make sure X coordinates do not go before the line data.
	else if(ssi_x - L_mouse.ssi_indent < 0)	{
		return(False);
	}

	//	Adjust for X coordinates.
	//	Should now be a correct offset.
	sli_offset += ssi_x - L_mouse.ssi_indent;

	//	Go through each anchor with a child.
	auto TextAttribute *TAp_mouse;
	for(signed short int ssi_find = 0; ssi_find < TNSCp_anchors->
		getCount(); ssi_find++)	{

		//	Extract an anchor.
		TAp_mouse = (TextAttribute *)(TNSCp_anchors->at(ssi_find));

		//	Continue if not in range.
		if(TAp_mouse->inRange(sli_offset) == 0)	{
			continue;
		}

		//	Inside and valid, select it.
		TAp_selected = TAp_mouse;
		return(True);
	}

	//	Never found.
	return(False);
}
