//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TextAttribute
//	Include File:	textattr.h
//	Purpose:	Implement a way of giving a WWW style of attribute to
//			a segment of a stream of data.
//	Remarks/Portability/Dependencies/Restrictions:
//		The difference between the start and end of an attribute is
//		called extent.  Extent can be considered a correlation to
//		calling strlen on a string.
//		An extent of 0 means no duration, 1 means 1 byte, etc...
//		A negative extent is equivalent to 0 extent.
//		Once an attribute type is set by the constructor, it can
//		never be changed.
//	Revision History:
//		02-01-94	created
//		02-09-94	Split all members into seperate files.
#include"textattr.h"

unsigned char TextAttribute::inRange(const signed long int sli_Offset)
	const	{
//	Purpose:	Decide if an offset is within the anchor.
//	Arguments:	sli_Offset	The offset to check and see if in
//					range.
//	Return Value:	unsigned char	== 1	In side of the attribute.
//					== 0	Not in side of the attribute.
//	Remarks/Portability/Dependencies/Restrictions:
//		An extent of 0 means no duration; always fail.
//		The end offset into the stream is actually always considered
//		one past the bytes affected by the attribute.
//	Revision History:
//		02-01-94	created

	if(getExtent() == 0L)
		return(0);

	if(sli_StreamOffset <= sli_Offset && sli_StreamExtent > sli_Offset)
		return(1);
	return(0);
}