//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx
//	Include File:	tdoslynx.h
//	Purpose:	Application object implementation
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-19-94
#define Uses_TFileDialog
#define Uses_TDeskTop
#include"tdoslynx.h"
#include"trace.h"
#include"globals.h"
#include"urltodos.h"
#include"turlwind.h"
#include<ctype.h>

void TDosLynx::OpenLocal(const char *cp_path)	{
//	Purpose:	Open a local file.
//	Arguments:	cp_path	the file to open if specified.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Once a suitable file name has been extracted from the user,
//		it will be turned into a url.  This function looks a lot like
//		OpenURL.
//	Revision History:
//		01-19-94	created
//		04-07-94	Added functionality to include a filename
//				in the call to OpenLocal.  If not specified,
//				the user will be promted for one.

#ifndef RELEASE
	trace("Opening local file.");
#endif // RELEASE

	if(cp_path == NULL)	{
		//	Create the input dialog
		TFileDialog *TFD = (TFileDialog *)validView(new TFileDialog("*.*",
			"Open Local", "File", fdOpenButton, usi_OpenLocalHist));

		//	If the dialog was allocated and was successfully executed
		//	without the user cancelling.
		if(TFD != NULL && deskTop->execView(TFD) != cmCancel)	{
			//	Small buffer to hold file name
			auto char ca_buffer[usi_TILURLSize];

			//	Get the information from the Dialog
			TFD->getFileName(ca_buffer);

			//	Remove whitespace from the front of the line.
			if(isspace(ca_buffer[0]))	{
				char *cp_temp = ca_buffer + 1;

				while(isspace(*cp_temp))
					cp_temp++;

				int i_traverse;
				for(i_traverse = 0; *cp_temp != '\0'; i_traverse++)
					ca_buffer[i_traverse] = *cp_temp++;

				ca_buffer[i_traverse] = '\0';
			}

			//	Only if we actually received a file name
			if(ca_buffer[0] != '\0')	{
				//	Convert the DOS file path to a url.
				char ca_dos2url[usi_TILURLSize];
				dostourl(ca_dos2url, ca_buffer);

				//	Create a new valid window
				TView *TV_new = validView((TView *)new
					TURLWindow(ca_dos2url));
				//	if not created, don't insert to desktop.
				if(TV_new != NULL)	{
					deskTop->insert(TV_new);
				}
			}
		}

		//	Done with the dialog.
		if(TFD != NULL)	{
			destroy(TFD);
		}
	}
	else	{
		//	local filename already specified.  Load it.

		//	Convert the DOS file path to a url.
		char ca_dos2url2[usi_TILURLSize];
		dostourl(ca_dos2url2, cp_path);

		//	Create a new valid window
		TView *TV_new2 = validView((TView *)new
			TURLWindow(ca_dos2url2));
		//	if not created, don't insert to desktop.
		if(TV_new2 != NULL)	{
			deskTop->insert(TV_new2);
		}
	}
}