#ifndef __TEXTATTRIBUTE_H
//	Avoid include redundancy
#define __TEXTATTRIBUTE_H

//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Include File:	textattr.h
//	Purpose:	Class implementation of a WWW style of attributes
//			possible on a stream of data.
//	Remarks/Portability/Dependencies/Restrictions:
//		Revised the paragraph to hold an index variable if included
//		in a list to help with a problem when used in a TNSCollection.
//		For some reason, it is a fatal error in doslynx.
//	Revision History:
//		02-01-94	created

//	Constant defines

//	Required includes
extern "C"	{
#include"htanchor.h"
};

//	Class declarations
class TextAttribute	{
public:
	//	The different type of attributes possible.
	enum AttributeType	{
		anchor		=	0x1,
	};

	//	A pointer to the attribute structure or other useful
	//	information for a text attribute.
	union	{
		const HTChildAnchor *HTCAp_anchor;
	};

	//	Constructors.
	//	for child anchor.
	TextAttribute(const HTChildAnchor *HTCAp, const signed long int
		sli_Offset = 0L, const signed long int sli_OffsetPlusExtent
		= 0L);

	//	Destructor.
	~TextAttribute();

	//	Set the offset.
	void Begin(const signed long int sli_Offset);
	//	End the offset.
	void End(const signed long int sli_OffsetPlusExtent);
	//	Return the beginning offset.
	signed long int getBegin() const;
	//	Return the ending offset.
	signed long int getEnd() const;
	//	Return the type of attribute
	AttributeType getType() const;
	//	Return the extent of an attribute
	signed long int getExtent() const;
	//	Return whether or not a stream offset is in the range of
	//	an attribute.
	unsigned char inRange(const signed long int sli_Offset)
		const;
private:
	//	The specific type of attribute that this is.
	AttributeType AT_StreamType;
	//	The offset of where the attribute begins in a stream.
	signed long int sli_StreamOffset;
	//	The offset of where the attribute once ends.
	signed long int sli_StreamExtent;
};

//	Global variable declarations

//	Macros

#endif // __TEXTATTRIBUTE_H
