/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
 *
 * $Log:	display.c,v $
 * Revision 1.5  92/04/28  15:25:21  jonathan
 * Changed use of Scrolllist.
 * 
 * Revision 1.4  92/03/17  14:16:13  jonathan
 * Generally cleaned things up.
 * 
 */

#ifndef lint
static char *RCSid = "$Header: /tmp_mnt/net/quake/proj/wais/wais-8-b5/x/RCS/display.c,v 1.5 92/04/28 15:25:21 jonathan Exp $";
#endif

#define XWAIS
#include "xwais.h"

static ScrollList
MakeQuestionFrame(parent)
Widget parent;
{
  Widget frame, labelwid, button;
  Widget view;
  ScrollList result;
  Arg arglist[10];
  Cardinal num_args;

  frame = XtCreateManagedWidget("questions", formWidgetClass, parent, NULL, ZERO);

  labelwid = MakeLabel(frame, "questionlabel", "Questions:", NULL, NULL);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++;
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("qview", viewportWidgetClass,
				frame, arglist, num_args);

  result =
    MakeScrollList(view, "questionWindow", Question_items, 
		   EditQuestion, NULL, NULL);

  button = MakeCommandButton(frame, "qadd", AddQuestion,
			     view, NULL, NULL);
  button = MakeCommandButton(frame, "qedit", EditQuestion,
			     view, NULL, NULL);
  button = MakeCommandButton(frame, "qdelete", DeleteQuestion,
			     view, NULL, NULL);
  return result;
}

static ScrollList
MakeSourceFrame(parent)
Widget parent;
{
  Widget frame, labelwid, button, view;
  ScrollList result;
  Arg arglist[10];
  Cardinal num_args;

  frame = XtCreateManagedWidget("tsources", formWidgetClass, parent, NULL, ZERO);

  labelwid = MakeLabel(frame, "sourcelabel", "Sources:", NULL, NULL);

  num_args = 0;
  XtSetArg (arglist[num_args], XtNforceBars, True); num_args++;
  XtSetArg (arglist[num_args], XtNallowVert, True); num_args++;

  view = XtCreateManagedWidget ("tsview", viewportWidgetClass,
				frame, arglist, num_args);

  result =
    MakeScrollList(view, "sourceWindow", Source_items, 
		   EditSource, NULL, NULL);

  button = MakeCommandButton(frame, "sadd", AddSource,
			     view, NULL, NULL);
  button = MakeCommandButton(frame, "sedit", EditSource,
			     view, NULL, NULL);
  button = MakeCommandButton(frame, "sdelete", DeleteSource,
			     view, NULL, NULL);
  return result;
}

static Widget
MakeMessage(parent)
Widget parent;
{
  Widget stringlabelwid;
  Arg arglist[10];
  Cardinal num_args;

  stringlabelwid = MakeLabel(parent, "mainstatuslabel", "Status:",
			     NULL, NULL);
  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextEdit); num_args++;
  XtSetArg(arglist[num_args], XtNsensitive, False); num_args++;
  XtSetArg(arglist[num_args], XtNfromVert, stringlabelwid); num_args++;
  return XtCreateManagedWidget("messageWindow", asciiTextWidgetClass,
			       parent, arglist, num_args);
}

static Widget
MakeSourcePopup(parent)
Widget parent;
{
  Widget shell, frame, labelwid, stringlabelwid, button;
  WidgetClass wclass;
  static String
    namestring,
    serverstring,
    servicestring,
    dbstring,
    cost, units,
    maintainer,
    description;
  int CurrentSource;
  Source source;

  CurrentSource = get_selected_source();

  if (CurrentSource != NO_ITEM_SELECTED) {
    source = findSource(CurrentSource);
    namestring = source->name;
    serverstring = source->server;
    servicestring = source->service;
    dbstring = source->database;
    cost = source->cost;
    units = source->units;
    maintainer = source->maintainer;
    description = source->description;
  } else {
    namestring = "default";
    serverstring = "localhost";
    servicestring = "8000";
    dbstring = "";
    cost = "";
    units = "";
    maintainer = "";
    description = "";
  }

  shell = XtCreatePopupShell("sourcepopup", applicationShellWidgetClass,
			     parent, NULL, ZERO);
  frame = XtCreateManagedWidget("sourcepopupform", formWidgetClass,
				shell, NULL, ZERO);

  labelwid = MakeLabel(frame, "sourceditlabel", "Source Edit", NULL, NULL);

  stringlabelwid = MakeLabel(frame, "sourcenamelabel", "       Name:", labelwid, NULL);
  snamewid = MakeStringBox(frame, "sourcename", namestring, labelwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "serverlabel",     "     Server:", snamewid, NULL);
  serverwid = MakeStringBox(frame, "server", serverstring, snamewid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "servicelabel", "    Service:", serverwid, NULL);
  servicewid = MakeStringBox(frame, "service", serverstring, serverwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "dblabel",      "   Database:", stringlabelwid, NULL);
  dbwid = MakeStringBox(frame, "database", dbstring, servicewid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "costlabel",    "       Cost:", stringlabelwid, NULL);
  costwid = MakeStringBox(frame, "cost", cost, dbwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "unitlabel",    "      Units:", stringlabelwid, NULL);
  unitwid = MakeStringBox(frame, "costunit", units, costwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "maintlabel",   " Maintainer:", stringlabelwid, NULL);
  maintainerwid = MakeStringBox(frame, "maintainer", maintainer, unitwid, stringlabelwid);

  stringlabelwid = MakeLabel(frame, "desclabel",    "Description:", stringlabelwid, NULL);
  descwid = MakeStringBox(frame, "description", description, stringlabelwid, NULL);

  button = MakeCommandButton(frame, "sdone", CloseSourceEdit, descwid, NULL, NULL);
  MakeCommandButton(frame, "cancel", CancelSourceEdit, descwid, button, NULL);

  return shell;
}

Widget
SetupWaisDisplay(parent)
Widget parent;
{
  Widget form, button;

  form = XtCreateManagedWidget ("form", formWidgetClass,
				parent, NULL, ZERO);

  questionwindow = MakeQuestionFrame(form);

  sourcewindow = MakeSourceFrame(form);

  button = MakeCommandButton(form, "help", XwaisHelp,
			     NULL, NULL, NULL);

  MakeCommandButton(form, "quit", DoQuit, NULL, button, NULL);

  messwidget = MakeMessage(form);

  sourcepopup = MakeSourcePopup(top);

  return form;
}
