/*
 * Copyright 1993, Bunyip Information Systems. This file is part of the
 * Bunyip WHOIS++ distribution and may be freely distributed as long as
 * this notice remains intact. This file may not be used in any product for
 * commercial gain.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <strings.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <memory.h>
#include "whois.h"
#include "whoisd.h"


constraint_set_t constraint_set[] = {
   { CON_HOLD, "HOLD", "Hold the connection for next query", "<\"true\",\"FALSE\">", C_SGLOBAL},
   { CON_MAXHITS, "MAXHITS", "Maximum number of responses", "<100>", C_SGLOBAL},
   { CON_LOGICAL, "LOGICAL", "Logical connection between search terms", "<\"AND\",\"or\">", C_SGLOBAL},
   { CON_MATCH, "MATCH", "Type of match", "<\"STANDARD\",\"initial\">", C_SLOCAL},
   { CON_LAST, ""}
};

   


int get_input(logfp)
   FILE *logfp;
{
   extern int hold;
   extern int maxhits;
   extern Val logical;

   char input[2048];
   WItem *input_list;
   Val intype;
   WItem *glob_cons;
   int j;
   char *lhs, *rhs;
   WItem *result;
   int addrsize;
   struct sockaddr_in cliaddr ;
   struct stat statbuf;


   if(logfp){
      fstat(fileno(stdin), &statbuf);

      if(S_ISSOCK(statbuf.st_mode)){

	 addrsize = sizeof(struct sockaddr_in);
	 
	 memset((char *)&cliaddr, 0, sizeof( struct sockaddr_in )) ;

	 if( getpeername( fileno(stdin), &cliaddr, &addrsize) == -1)
	    return(-1);

	 fprintf(logfp, "%16s: ", inet_ntoa(cliaddr.sin_addr));
      }
   }

start:

   hold = 0;
   input[0] = '\0';



   wGetLine(stdin, input, sizeof(input));

   if(logfp)
      fprintf(logfp, "%s\n", input);

   if((input_list = wQueryParse(input)) == (WItem *) NULL){

      wPutLine(stdout, wErrorReply(WERR_BAD_INPUT, "%s", input));
      return(-1);
   }

   /* Make sure that we're at the head of the list */

   if(wGetFormat(input_list) != F_HEAD){
      wPutLine(stdout, wErrorReply(WERR_INTERNAL, "%s", "Unexpected format"));
      return(-1);
   }

   result = wCreateReply(R_FULL, -1);

   /* Check to see if there are any global constraints */

   if((glob_cons = wFirstConstraint(input_list)) != (WItem *) NULL){

      do{
	 int found = 0;

	 /* process constraints */

	 rhs = wGetRHS(glob_cons);
	 lhs = wGetLHS(glob_cons);


	 for(j = 0; !found && (j < CON_LAST); j++){
	    if(strcasecmp(lhs, constraint_set[j].con_name) == 0){

	       if(constraint_set[j].con_scope != C_SGLOBAL){
		  wAppendSystemMessage(result, wErrorReply(WWARN_CON_NOT_GLOBAL, "%s", lhs));
		  break;
	       }

	       found = 1;
	       switch(j){

		  case CON_HOLD:
		     if(strncasecmp(rhs, "TRUE", strlen(rhs)) == 0)
			hold = 1;
		     else if(strncasecmp(rhs, "FALSE", strlen(rhs))){
			hold = 0;
			wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_CONST_VAL, "%s: %s", lhs, rhs));
		     }
		     break;

		  case CON_MAXHITS:
		     if(sscanf(rhs, "%d", &maxhits) != 1){
			wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_CONST_VAL, "%s: %s", lhs, rhs));
			maxhits = DEF_MAXHITS;
		     }
		     break;

		  case CON_LOGICAL:
		     if(strncasecmp(rhs, "OR", strlen(rhs)) == 0)
			logical = WOR;
		     else if(strncasecmp(rhs, "AND", strlen(rhs))){
			wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_CONST_VAL, "%s: %s", lhs, rhs));
			logical = WAND;
		     }
		     break;
	       }
	    }
	 }

	 if(!found)
	    wAppendSystemMessage(result, wErrorReply(WWARN_NO_CONSTRAINT, "%s", lhs));

      }while((glob_cons = wNextItem(glob_cons)) != (WItem *) NULL);
   }

   switch(intype = wGetType(input_list)){

      case T_SEARCH:
	 if(do_search(input_list, result) == 0)
	    wPutLine(stdout, wErrorReply(WINFO_OK, ""));
	 break;

      case T_SYSTEM:

	 do_system(input_list, result);
	 break;

      case T_CONS:
      case T_REPLY:
      default:
      break;
   }

   wReply(result, stdout);
   wFreeList(result);
   wFreeList(input_list);

   if(hold){
      wPutLine(stdout, wErrorReply(WINFO_HOLDING, ""));
      goto start;
   }
   else
      wPutLine(stdout, wErrorReply(WINFO_CLOSING, "See Ya."));

   return(0);
}
