#ifdef	RCSIDENT
static char rcsid[]="$Header: /g1/users/staff/gore/exp/notes/src/RCS/seqset.c,v 2.0 89/04/16 00:36:50 gore Exp $";
#endif	RCSIDENT

/*
 *	seqset - set the sequencer to a specified date.
 */

#include "parms.h"
#include "structs.h"
#include <sys/stat.h>

/* #define DEBUG	/* */

static long arch_time;		/* The archiver time */
static time_t zaptime;		/* The oldest possible note to send */
static time_t sincetime;	/* The user specified time */
static time_t dflttime;		/* The time to use if no sequencer time */
extern int errno;
int ignsigs = 0;

main(argc, argv)
char **argv;
{
	int i; 
	struct nfile *np;
	char sequencer[WDLEN];
	char *tosys = 0;
	time_t when;

	initenv();

	if (argc == 1) {
	    usage(argv[0]);
	    exit (BAD);
	}

	/* MAYBE ALLOW DIRECTOR'S TOO? */
	if (globuid != notesuid) {
		fprintf(stderr, "Sorry, only notes 'owner' can set the sequencers\n");
		exit(BAD);
	}

	/* when do we send from if no sequencer date?   If not overridden
	   use two days ago */
	time (&dflttime);
	dflttime -= 2 * DAYSECS;   /* if no override, only last two days */

	/*  What is the archive period? */
	arch_time = igetconfig ("Archive-Days");
	if (arch_time < 0)
	    arch_time = ARCHTIME;

	/* When is that as a date? */
	time (&zaptime);
	if (igetconfig ("Allow-Old"))	/* zap if missing or "true" */
	    zaptime = 0;
	else
	    zaptime -= (long) arch_time * DAYSECS;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {

			case 'f': 		/* process a file */
				readrc(argv[++i]);
				break;

			case 't':
				tosys = argv[++i];
				break;

			case 'w':	/* When: use instead of sequencer */
				sincetime = getdate(argv[++i], (struct timeb *)0);
				if (sincetime == -1) {
					fprintf(stderr, "Bad date: %s\n", argv[i]);
					usage(argv[0]);
					exit(BAD);
				}
				sprdate(sincetime, sequencer);
				fprintf(stderr,"Setting sequencer to %s\n",
					sequencer);
				break;
			default: 
				fprintf(stderr, "Bad switch: %c\n", argv[i][1]);
				usage(argv[0]);
				exit(BAD);
			}
		} else {
			expand(argv[i]);
		}
	}

	if (tosys == 0)
		tosys = hostname_in_path;
	sprintf(sequencer, "%s/%s/%s.seq", libdir, RMTDIR, tosys);
	readseq(sequencer, 1);
	for (np = nfile; np; np = np->n_next) {
		if (np->n_lookat == 0)
			continue;
		/*
		 * This is an area of policy, which currently is:
		 * 1) use the sequencer's date (no-op)
		 * 2) if there is no sequencer entry, use two days.
		 *    (2 is arbitrary, but "short but not empty").
		 *    This sets things up in the case of starting a new site.
		 *    (My experience indicates that this is about right to
		 *    prevent mistakes.)
		 * 3) if the user specified a date with -w, use that
		 * 4) if that date would send stuff older than Archtime,
		 *    ask about it.  (Since we don't want this to happen
		 *    without a very good reason, this gets asked each time
		 *    a new group is sent.  Besides it's much easier to
		 *    implement that way when variable Archtimes come along.
		 *    :-) )
		 */
		when = np->n_when;
		if (when == 0) when = dflttime;  /* no sequencer date: 2 days */
		if (sincetime != 0) when = sincetime;
	        if (when < zaptime) {
			char c;
			register char c1;

			fprintf(stderr,"Selected time older than archive period for %s.\nSet it anyway? (y/n) ", np->n_name);
			c = getc(stdin);		/* grab 1 from the tty */
			if (c != '\n' && c != EOF) {
			    while ((c1 = getc(stdin)) != '\n' &&
			    	c1 != EOF); /* suck to eol or EOF (for batch) */
			}
			if (c != 'y') {
			    continue;			/* don't change */
			}
		}
		if (when != np->n_when) updseq (np->n_name, when);

	}
	writeseq(sequencer);
	exit(GOOD);
}

usage (invokedas)
char *invokedas;
{
	fprintf(stderr,
	    "Usage: %s [-t tosys] [-f file] [-w since] topic1 [topic2 ...]\n",
	    invokedas);
}
