/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/rmnf.c,v 2.0 89/04/16 00:35:41 gore Exp $ */

#define dprintf if (0) printf
/*
 *	rmnf - remove notefiles 
 *	rmnf removes the notefiles specified on the control card.
 *	It also goes through and cleans out the sequencer files
 *	that had entries for that notefile.
 *
 *	Since this can sort of destroy a lot of information, we
 *	ask for confirmation of the removal.
 *
 *	Original Coding: Ray Essick	December 1981
 */

#include "parms.h"
#include "structs.h"
extern char *rindex();

main(argc, argv)
int argc;
char  **argv;
{
    int     i,j;
    int     force = 0;
    int	    quick = 0;
    int     modified = 0;
    int    c;
    char   cmdline[128];
    char   tmpname[1024];
    char   nfname[NNLEN];
    char   *p;

    initenv();

    if (globuid != notesuid) {
	printf("You are not allowed to remove notefiles\n");
	exit(BAD);
    }

    if (argc == 1) {
	usage (argv[0]);
	exit (BAD);
    }

    for (i = 1; i < argc; i++) {

	if (argv[i][0] == '-') {/* options!!! */
	    j = 1;
	    while (argv[i][j])
		switch (argv[i][j++]) {
		    case 'f':
			force = 1;
			break;

		    case 'q': 	
			quick = 1;
			break;

		    default: 	/* bad news */
			fprintf (stderr, "Bad switch: `%c'\n", argv[i][--j]);
			usage (argv[0]);
			exit (BAD);
		}
	    continue;		/* on to the next arguement */
	}

	if (chkpath(argv[i]) == -1) {
	    printf("%s: Bad notefile name\n", argv[i]);
	    continue;
	}

	safecpy (nfname, argv[i], NNLEN);
	strcpy (tmpname, mapnfname (nfname));

	if (force == 0) {
	    printf("Really remove %s? ", argv[i]);
	    c = getchar();			/* grab 1 from the tty */
	    if (c != '\n') {
		while (getchar() != '\n');	/* suck to eol */
	    }
	    if (c != 'y') {
		continue;			/* don't delete */
	    }
	}
	modified = 1;	       	/* assume that we really will remove it */

	dprintf ("rmnf: mapping \"%s\" to \"%s/%s\"\n",
	    argv[i], spooldir, tmpname);
	x (chdir(spooldir) < 0,
		"rmnf: bad chdir to spooldir, \"%s\"", spooldir);

	if (chdir(tmpname) < 0) {
	    printf("rmnf: \"%s\" -- Can't delete or non-existent\n", argv[i]);
	    continue;
	}
	dprintf ("rmnf: done chdir, starting rm\n");
#ifdef MSGID_INDEX
	sprintf (cmdline, "exec rm -f %s %s %s %s %s %s.dat %s.map",
		 TEXT, INDEXN, INDEXR, ACCESS, STRPOOL,
		 MSGID_INDEX, MSGID_INDEX);
#else /*!MSGID_INDEX*/
	sprintf (cmdline, "exec rm -f %s %s %s %s %s",
		 TEXT, INDEXN, INDEXR, ACCESS, STRPOOL);
#endif MSGID_INDEX
	dosystem("/bin/sh", "-c", cmdline, NOSTR);

	x (chdir("..") < 0, "rmnf: bad chdir to \"..\"");
	
	if (NULL != (p = rindex (tmpname, '/')))
	    strcpy (cmdline, ++p);
	else
	    strcpy (cmdline, tmpname);

	dprintf ("rmnf: done chdir .. into \"%s\", going to rm \"%s\"\n",
		getcwd (tmpname, 1024), cmdline);

	/* the rmdir will fail if the directory isn't empty, which
	 * is exactly what we want (there could be other subgroups).
	 */

#ifdef BSD4_2
	rmdir(cmdline);
#else
	dosystem("/bin/rmdir", cmdline, NOSTR);
#endif BSD4_2

	printf("%s: Deleted\n", argv[i]);

/*	now we get to remove the sequencer entries 
 *	This is a little complicated for sitting and typing from the top
 *	of my head, so I will write it out later and type it in.
 *	Have to do stuff which include opening the sequencer directory
 *	and reading all the names from it to get the file names..
 *	Then have to sequence through each file doing
 *	 while ( more) { read; if (not one deleting) {write;count++} }
 *	Also if don't write any - unlink the file.
 *
 */
    }
    if (!quick && modified) {	/* skip this if we didn't remove anything */
	    sprintf (cmdline, "%s/%s", libdir, MAKEACTIVE);
	    dosystem (cmdline, spooldir, NOSTR);
    }
    exit (GOOD);
}

usage(invokedas)
char *invokedas;
{
	printf ("Usage: %s [-fq] topic1 [...]\n", invokedas);
	printf ("\t-f = force removal (doesn't ask yes/no)\n");
	printf ("\t-q = quick (don't rebuild active)\n");
}
