#ifdef	RCSIDENT
static char rcsid[]="$Header: /g1/users/staff/gore/exp/notes/src/RCS/newsoutput.c,v 2.0 89/04/16 00:18:38 gore Exp $";
#endif	RCSIDENT

/*
 *	newsoutput - place the specified notesfiles out to the
 *	news susbsystem. 
 */

#include "parms.h"
#include "structs.h"
#include <sys/stat.h>
#include "dumpmsg.h"

#define CONTROL

#ifdef TEMPNNTP

#include <errno.h>

#  ifndef NNTPOUTDIR
#    define NNTPOUTDIR "/usr/notes/nntp-out"
#  endif  NNTPOUTDIR

static char nntp_spool_dir[PATHLEN];
static int nntp = 0;

#endif TEMPNNTP

static char tmpname[WDLEN];
static long size;
static long arch_time;
static time_t zaptime;		/* The oldest possible note to send */
static time_t dflttime;		/* The time to use if no sequencer time */
extern int errno;

main(argc, argv)
char **argv;
{
	int i; 
	struct nfile *np;
	char sequencer[WDLEN];
	char *tosys = 0;
	int noupdate = 0;
	int notesformat = 0;
	int archive = 0;
	int maxsize = -1;
	time_t when;
	long atol();

	initenv();

	if (argc == 1) {
	    usage(argv[0]);
	    exit (BAD);
	}

	/* MAYBE ALLOW DIRECTOR'S TOO? */
	if (globuid != notesuid) {
		fprintf(stderr,
			"Sorry, only notes 'owner' can send notes to news\n");
		exit(BAD);
	}

	time (&zaptime);
	time (&dflttime);
	dflttime -= 2 * DAYSECS;   /* if no override, only last two days */

	/* Get the time limit for articles that are too old to send out */
	arch_time = igetconfig ("Junk-Days");
	if (arch_time == -1)	/* not present, use Archive-Days */
	    arch_time = igetconfig("Archive-Days");
	if (arch_time == -1)	/* not present, take the hard default */
	    arch_time = ARCHTIME;

	if (igetconfig ("Allow-Old"))	/* zap if missing or "true" */
	    zaptime = 0;
	else
	    zaptime -= (long) arch_time * DAYSECS;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {

			case 'f': 		/* process a file */
				readrc(argv[++i]);
				break;

			case 't':
				tosys = argv[++i];
				break;

			case 'n':
				noupdate++;
				break;

			case 's':
				maxsize = atol(argv[++i]);
				break;

			case 'o':	/* Use Notes 1.6 format (old) */
				notesformat++;
				break;
			case 'A':	/* Spit out a full archive */
				noupdate++;
				archive++;
				zaptime = 0;
				break;
			case 'N':	/* Output intended for NNTP */
				nntp++;
				break;
			default: 
				fprintf(stderr,
					"Bad switch: %c\n", argv[i][1]);
				usage(argv[0]);
				exit(BAD);
			}
		} else {
			expand(argv[i]);
		}
	}

	if (tosys == 0)
		tosys = hostname_in_path;

#ifdef TEMPNNTP

	if (nntp) {
	    char *nntp_spool_area;
#ifdef __STDC__
	    char *getconfig(char*);
#else
	    char *getconfig();
#endif
	    /*
	     * Figure out the name of the nntp spool directory for
	     * this system, and create it if it is not already there.
	     */
	    if ((nntp_spool_area = getconfig("NNTP-Spool-Out")) == NULL) {
		nntp_spool_area = NNTPOUTDIR;
	    }
	    sprintf(nntp_spool_dir, "%s/%s", nntp_spool_area, tosys);
	    if(mkdir(nntp_spool_dir, 0770) < 0) {
		if (errno != EEXIST) {
		    log("newsoutput: cannot create NNTP directory '%s'",
			nntp_spool_dir);
		    exit(BAD);
		}
	    }

	} else {
#endif TEMPNNTP

	    /* If not for NNTP, we'll need a temporary file to spool to. */
	    sprintf(tmpname, "%s/nfoutXXXXXX", TMPDIR);
	    mktemp(tmpname);

#ifdef TEMPNNTP
	}
#endif TEMPNNTP
	sprintf(sequencer, "%s/%s/%s.seq", libdir, RMTDIR, tosys);
	readseq(sequencer, 1);
	for (np = nfile; np; np = np->n_next) {
		if (np->n_lookat == 0)
			continue;
#ifdef HPVERSION
		/* Safety Net:  Do not send HP newsgroups to non-HP sites. */
		if ((cstrncmp("hp",np->n_name,2) == 0) &&
		    (cstrncmp("hp",tosys,2)      != 0)) {
		    log(
		    "newsoutput: Foiled attempt to send \"%s\" to site \"%s\"",
			np->n_name, tosys);
		    continue;
		}
#endif /* HPVERSION */
		/*
		 * If the sequencer comes up with "since forever" (which
		 * implies there was no sequencer entry), use dflttime
		 * instead.
		 *
		 * If we are making an archive batch (-A flag), set
		 * sequencer to time 0 to get all articles.
		 */
		when = np->n_when;
		if (when == 0) when = dflttime;  /* no sequencr date: 2 days */
		if (archive) when = 0;

		newsout(np->n_name, when, tosys, notesformat, archive);
#ifdef TEMPNNTP
		if (!nntp && (maxsize > 0 && size > maxsize))
			break;
#else
		if (maxsize > 0 && size > maxsize)
			break;
#endif TEMPNNTP
	}
	if (!noupdate)
		writeseq(sequencer);
#ifdef TEMPNNTP
	if (!nntp)
#endif TEMPNNTP
	  unlink(tmpname);
	exit(GOOD);
}

/*
 * Send new articles from one notesfile.  If the notesformat flag is
 * non-zero, the articles are send in notes format rather than news.
 *
 * If extensive is non-zero, and notesformat is non-zero, a notes
 * archive is made (nfdump/nfload format).  A notes archive includes
 * a line recording the date received.  Notes archives are for
 * back-compatability only.
 */

newsout (nfname, wdate, tosys, notesformat, extensive)
char   *nfname;
time_t wdate;
char   *tosys;
{
    register    FILE * rnews;
    register int    c;
    struct io_f io;
    struct note_f   note;
    struct resp_f   rsprec;
    struct msg_f   *msgp;
    time_t whendump;		/* when we did this */
    int     notenum,
            respnum,
            rdumped,
            ndumped,
            roffset,
            rblock;
    int     local;
    struct stat sb;
    struct txthead_f txthead;
    char    path[PATHLEN];

    /* efficiency hack */
    if (nfmod_before (nfname, wdate))
	return (0);

    if (init (&io, nfname) < 0) {/* open the bugger */
	fprintf (stderr, "Can't open notesfile `%s'\n", nfname);
	log ("newsoutput: %s: can't open", nfname);
	return (-1);
    }
    if (!extensive &&		/* able to archive non-networked nf's */
	(io.descr.d_stat & NETWRKD) == 0) {
				/* are we permitted to gate? */
	closenf (&io);
	fprintf (stderr, "%s must be networked to go to news\n", nfname);
	log ("newsoutput: %s: not networked", nfname);
	return (-1);
    }
    local = (strcmp (tosys, hostname_in_path) == 0);

    time (&whendump);		/* for updating last access */
    io.stime = wdate;

    ndumped = rdumped = 0;
    notenum = 0;		/* start at the top */

    if (notesformat) {
	rnews = fopen (tmpname, "w");
	if (NULL == rnews) {
	    fprintf(stderr,
		    "newsoutput: can't open scratch file \"%s\" for writing\n",
		    tmpname);
	    return (-1);
	}
    }

    while ((notenum = nxtnote (&io, notenum, io.stime)) != -1) {
	getnrec (&io, notenum, &note);/* get descriptor */
	respnum = -1;
	while ((respnum = nxtmsg (&io, notenum, respnum, io.stime)) != -1) {
	    if (respnum == 0)
		msgp = &note.n_msg;
	    else {
		if (lrsp (&io, notenum, respnum, &rsprec,
			    &roffset, &rblock) == -1)
		    break;
		msgp = &rsprec.r_msg[roffset];
	    }

	    gethdr (&io, msgp, msgp -> m_path, path);
	    if ( !extensive  &&			/* never skip if archiving */
		 ((local && (msgp -> m_stat & FRMNEWS)) || /* news gateway */
		  inpath (tosys, path)))	/* skip if tosys has seen it */
		continue;
	    if (msgp -> m_subtime < zaptime) {
		char    msgid[IDSZ];
		gethdr (&io, msgp, msgp -> m_artid, msgid);
		fprintf (stderr,
	 "newsoutput: %s in %s skipped, older than archive period (%d days)\n",
			 msgid, nfname, arch_time);
		continue;
	    }

	    /*
	     * We take a moment to cull out the undesirables before
	     *  transmitting anything.
	     */
	    if (msgp -> m_stat & ORPHND)
	        continue;	/* DO NOT SEND OUT FOSTER PARENTS !! */

	    gethrec(&io, &msgp->m_addr, &txthead);
	    if (txthead.textlen == 0) {		/* Zero-length text ... */
#ifdef CONTROL
	        char ctlmsg[256];
		
	        gethdr (&io, msgp, msgp -> m_ctlmsg, ctlmsg);
		if(strlen(ctlmsg) != 0) {	/*.. and not control message */
		    continue;			/* Don't send that sucker */
		}
#else
		continue;
#endif CONTROL
	    }
		
	    if (notesformat) {
		if (respnum == 0)/* Use Oldnotes format */
		    dmpnote (&io, &note, notenum, rnews, extensive);
		else
		    dmpresp (&io, &note, notenum, rnews, respnum, extensive);
	    }
	    else {		/* Good.  Use News. */
		    /* 
#ifdef TEMPNNTP
		     * If not spooling an NNTP message,
#endif TEMPNNTP
		     * dump the message to a temporary file (sigh)
		     */
#ifdef TEMPNNTP
		if (nntp) {
		    /*
		     * The full file name for the spooled message:
		     *		<nntp_spool_area>/<tosys>/<Message-ID>
		     */
		    char    msgid[IDSZ];
		    gethdr (&io, msgp, msgp->m_artid, msgid);
		    sprintf(tmpname, "%s/%s", nntp_spool_dir, msgid);
		}
#endif TEMPNNTP
		if ((rnews = fopen (tmpname, "w")) == NULL) {
		    fprintf (stderr,
		    "newsoutput: can't open scratch file \"%s\" for writing\n",
			     tmpname);
		    continue;
		}
		dumpmsg (&io, &note, msgp, respnum, DMP_HEADED, rnews);
		fclose (rnews);
#ifdef TEMPNNTP
		if (!nntp) {
#endif TEMPNNTP
		    if (stat (tmpname, &sb) < 0) {
			fprintf (stderr,
				"newsoutput: can't stat scratch file \"%s\"\n",
				 tmpname);
			continue;
		    }
		    size += sb.st_size;
		    if ((rnews = fopen (tmpname, "r")) == NULL) {
			fprintf (stderr,
		    "newsoutput: can't open scratch file \"%s\" for reading\n",
				 tmpname);
			continue;
		    }
		    fprintf (stdout, "#! rnews %ld\n", sb.st_size);
		    while ((c = getc (rnews)) != EOF)
		      putc (c, stdout);
		    fclose (rnews);
#ifdef TEMPNNTP
		} /* news batch (not NNTP) */
#endif TEMPNNTP
	    }			/* news (not notesformat) */

	    if (respnum)
		rdumped++;
	    else
		ndumped++;
	}
    }

    if (notesformat)
        fclose (rnews);

    if (notesformat && (ndumped+rdumped)) {
	char cmdline[256];
	int ret, e;

	/*
	 * WARNING: we don't really get any useful information back from
	 * system() about whether or not the command worked.  To do this
	 * right, you'd need to popen() the command instead, and write
	 * to it, but since this is just temporary code, I won't bother.
	 *    - tw
	 */

	sprintf (cmdline, "%s/%s %s %s < %s", libdir,
		 "nfxmitsh", nfname, tosys, tmpname);
	ret = system (cmdline);
	e = errno;
	if (ret < 0) {
	    log ("%s: failed to send %d notes and %d responses to %s via %s",
		nfname, ndumped, rdumped, tosys,
		notesformat ? "OLDNOTES" : "NEWS");
	    fprintf (stderr, "newsoutput: system (\"%s\") failed", cmdline);
	    errno = e;
	    perror ("");
	    return (-1);
	}
    }
    updseq (nfname, whendump);

    if (ndumped + rdumped)
      {
	/* Record time of last transmit. */
	/* Users can't edit an item after it's been transmitted. */
	struct descr_f descr;
	long now;

	time(&now);
	getdscr (&io, &descr);
	descr.d_lstxmit = now;
	putdscr (&io, &descr);
      }

    if (ndumped + rdumped)
	log ("%s: sent %d notes and %d responses to %s via %s",
		nfname, ndumped, rdumped, tosys,
#ifdef TEMPNNTP
		notesformat ? "OLDNOTES" : (nntp ? "NNTP" : "NEWS"));
#else  TEMPNNTP
		notesformat ? "OLDNOTES" : "NEWS");
#endif TEMPNNTP
    finish (&io);
    return (0);
}

usage (invokedas)
char *invokedas;
{
	fprintf(stderr,
#ifdef TEMPNNTP
	 "Usage: %s [-o] [-A] [-N] [-t tosys] [-f file] topic1 [topic2 ...]\n",
#else  TEMPNNTP
	    "Usage: %s [-o] [-A] [-t tosys] [-f file] topic1 [topic2 ...]\n",
#endif TEMPNNTP
	    invokedas);
}
