/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/mknf.c,v 2.0 89/04/16 00:04:05 gore Exp $ */

#define dprintf if (0) printf

/*
 *	This program will initialize an empty notefile. It leaves the
 *	caller as sole director of the notefile and also as the only
 *	person with access to the notefile. 
 *
 *	Since a notefile does suck up a little disk space, the use of
 *	this program is limited to the user whose uid matches the
 *	NOTESUID constant in the file structs.h 
 *
 *	Modified to keep notesfiles in a heirarchy like news does;
 *	essential for those of us (sys 5) without infinitely long
 *	filenames.  Also beefed up the error messages substantially. - Tw
 *
 *
 *	Original coding:	Rob Kolstad	Winter 1980
 *	Modified:		Ray Essick	November 1981
 *	Modified:		Tw Cook		November 1985
 *	Modified:		Jacob Gore	Summer 1988-Spring 1989
 */

#include "parms.h"
#include "structs.h"
#include "acl.h"
#include <sys/stat.h>

extern char *index();
#ifdef __STDC__
extern char *mapnfname(char*);
#else
extern char *mapnfname();
#endif

#define NOT_VERBOSE	0
#define MUST_HAVE_MODE	1

main (argc, argv)
char  **argv;			/* create a new notesfile */
{
    int     k;			/* arg counter */
    int     j,
            Aflag,
            Oflag,
	    Qflag,
            Nflag,
	    Uflag;		/* option flags */
    int     modified = 0 ;	/* set to 1 when we actually make an nf */
    int     i;			/* misc counter */
    int     fid;		/* misc file id */
    struct daddr_f  freetext;	/* for writing */
    struct descr_f  descr;	/* for writing, too */
    ace_t  ace;			/* single access control entry */
    acl_t *aclp;		/* access control list */
    char   pstring[LBUFLEN];	/* to store permission string */
#ifdef __STDC__
    char   *getname(int);
#else
    char   *getname();
#endif
    char    cmdline[CMDLEN];	/* for mkdir */
    char    tmpname[LBUFLEN];	/* directory where we build the notesfile */
    char    nfname[NNLEN];
    char    atname[LBUFLEN];	/* access-template file */
    FILE * atfile;		/* access-template file */
    FILE * seqfile;
    struct stat statbuf;

    initenv ();

#ifndef AUTOCREATE
    if (globuid != notesuid) {
	printf ("You are not allowed to build notefiles\n");
	exit (BAD);
    }
#endif

    if (argc == 1) {
	usage (argv[0]);
	exit (BAD);
    }

    Aflag = 0;
    Oflag = 0;
    Nflag = 0;
    Qflag = 0;

    for (k = 1; k < argc; k++) {

	if (argv[k][0] == '-') {/* options!!! */
	    j = 1;
	    while (argv[k][j])
		switch (argv[k][j++]) {
		    case 'a': 	/* anon notes ok */
			Aflag = 1;
			break;

		    case 'o': 	/* open notesfile */
			Oflag = 1;
			break;

		    case 'n': 	/* network available */
			Nflag = 1;
			break;

		    case 'q':	/* quick (don't build Active) */
			Qflag = 1;
			break;

		    case 'u':	/* update Active regardless */
			Uflag = 1;
			break;
			
		    default: 	/* bad news */
			fprintf (stderr, "Bad switch: `%c'\n", argv[k][--j]);
			usage (argv[0]);
			exit (BAD);
		}
	    continue;		/* on to the next arguement */
	}

	if (chkpath (argv[k])) {
	    printf ("%s: invalid notesfile name: %s\n", 
	    	argv[0], argv[k]);
	    continue;
	}

	safecpy (nfname, argv[k], NNLEN);
	strcpy (tmpname, mapnfname (nfname));

	dprintf ("mknf: mapping \"%s\" into \"%s/%s\"\n",
		argv[k], spooldir, tmpname);

	setgid (notesgid);
	setuid (notesuid);

	printf ("%s\n", argv[k]); /* show progress */

	x (chdir (spooldir) < 0,
	   "mknf:  Can't chdir to \"%s\"", spooldir);

	if (chdir (tmpname) == 0) { /* check for existence */
	    if (0 == stat (ACCESS, &statbuf)) {
		printf ("%s: notesfile already exists, skipping\n", argv[k]);
		continue;
	    }
	}
	else {
	    char    fname[1024];
	    char   *p,
	           *q;

	    modified = 1;	/* if we get this far, say we made the nf */

	    strcpy (fname, tmpname);
	    q = fname;

	    while (1) {

		p = index (q, '/');
	        if (p != NULL)
		    *p = '\0';

	    	dprintf ("mknf: trying chdir(\"%s\") now\n", q);

		if (0 != chdir (q)) {
		    dprintf ("mknf: chdir failed, trying mkdir\n");

#ifdef BSD4_2

		    x (mkdir (q, 0770) < 0,
		        "mknf: can't make directory \"%s\"", q);
#else
		    dosystem ("/bin/mkdir", q, NOSTR);
		    dosystem ("/bin/chmod", "0770", q, NOSTR);
#endif BSD4_2

		    x (chdir (q) < 0,
		        "mknf: can't chdir to \"%s\"", q);
		}
		if (p == NULL)
		    break;
		else
		    q = ++p;
	    }
	}

	dprintf ("mknf: done with chdirs, now in \"%s\"\n",
		getcwd (tmpname, 1024));

	/* make the text file now */
	x ((fid = creat (TEXT, 0660)) < 0,
	    "mknf:  Can't create \"%s/%s/%s\"", spooldir, tmpname, TEXT);
	freetext.addr = sizeof (freetext);
				/* point after the address table */
	x (write (fid, (char *) & freetext, sizeof (freetext)) != sizeof (freetext),
		"mknf:  Can't write \"%s/%s/%s\"", spooldir, tmpname, TEXT);
	x (close (fid) < 0,
	    "mknf: failed to close \"%s/%s/%s\"", spooldir, tmpname, TEXT);

	/* make the note index now */

	glock (SEQLOCK);	/* grab next available sequence # */
	sprintf (cmdline, "%s/%s", libdir, SEQ);
	x ((seqfile = fopen (cmdline, "r")) == NULL,
	    "mknf: can't fopen sequence file \"%s/%s\"", libdir, SEQ);

	x (fscanf (seqfile, "%d", &i) != 1,
	    "mknf: can't read sequence file \"%s/%s\"", libdir, SEQ);

	descr.d_nfnum = i++;
	fclose (seqfile);	/* close it and then */

	x ((seqfile = fopen (cmdline, "w")) == NULL,
	    "mknf: can't reopen sequence file \"%s/%s\"", libdir, SEQ);

	fprintf (seqfile, "%d\n", i);
	fclose (seqfile);
	gunlock (SEQLOCK);	/* release unique file */

	descr.d_format = DBVERSION;
	safecpy (descr.d_title, argv[k], NNLEN);
	strcpy (descr.d_drmes, "** director message **");
	descr.d_plcy = 0;	/* no policy note at this time */
	descr.d_id = 0;		/* unique id number within nf */

	time (&descr.d_lstxmit);/* last network transmission */
	descr.d_lastm = descr.d_created = descr.d_lastuse = descr.d_lstxmit;
	descr.d_daysused = 1;	/* count making it ! */
	descr.d_stat = 0;	/* no special status now */
	if (Aflag) {
	    descr.d_stat |= ANONOK;/* he said wanted this */
	}
	if (Oflag) {
	    descr.d_stat |= OPEN;
	}
	if (Nflag) {
	    descr.d_stat |= NETWRKD;
	}
	descr.d_nnote = 0;	/* no notes in file */

	descr.d_rspwrit = descr.d_notwrit = 0;/* initialize stats */
	descr.d_rspread = descr.d_notread = 0;
	descr.d_notdrop = descr.d_rspdrop = 0;
	descr.d_orphans = 0;
	descr.netwrkouts = descr.netwrkins = 0;
	descr.entries = 0;
	descr.walltime = 0;
	descr.d_rspxmit = descr.d_notxmit = 0;
	descr.d_rsprcvd = descr.d_notrcvd = 0;
	descr.d_archtime = 0;
	descr.d_workset = 0;
	descr.d_archkeep = KEEPDFLT;
	descr.d_dmesgstat = DIRDFLT;

	x ((fid = creat (INDEXN, 0660)) < 0,
	    "mknf:  Can't create \"%s/%s/%s\"", spooldir, tmpname, INDEXN);

	x (write (fid, (char *) & descr, sizeof (descr)) != sizeof (descr),
	    "mknf:  Can't write \"%s/%s/%s\"", spooldir, tmpname, INDEXN);
	x (close (fid) < 0,
	    "mknf: failed to close \"%s/%s/%s\"", spooldir, tmpname, INDEXN);

	/* now make the response index, it's easy */
	x ((fid = creat (INDEXR, 0660)) < 0,
	    "mknf:  Can't create \"%s/%s/%s\"", spooldir, tmpname, INDEXR);

	i = 0;			/* resp 0 slot free */
	x (write (fid, (char *) & i, sizeof (i)) != sizeof (i),
	    "mknf:  Can't write \"%s/%s/%s\"", spooldir, tmpname, INDEXR);
	x (close (fid) < 0,
	    "mknf: failed to close \"%s/%s/%s\"", spooldir, tmpname, INDEXR);

/*
 *	Build the access list.  This is a two phase operation.
 *	The first phase builds a default access list.  This
 *	is set up with one director (the notes signon) and
 *	a group "Other" with read/write.  System "Other" also
 *	has read/write privileges.  This is basically a wide-open
 *	policy.
 *	The second phase is customization.  This step uses the
 *	contents of the file ..../notes/.utilities/access-template
 *	as a batch of access specifications (like nfaccess)
 *	to add/modify specific permissions. 
 */

	aclp = acl_create_quick(ACCESS);

	sprintf(pstring, "u:%s=rwad", getname(0));
	parsemode(pstring, &ace, MUST_HAVE_MODE, NOT_VERBOSE);
	acl_add(aclp, &ace);

	sprintf(pstring, "g:Other=%s", DFLTPRMST);
	parsemode(pstring, &ace, MUST_HAVE_MODE, NOT_VERBOSE);
	acl_add(aclp, &ace);

	sprintf(pstring, "s:Other=%s", DFLTPRMST);
	parsemode(pstring, &ace, MUST_HAVE_MODE, NOT_VERBOSE);
	acl_add(aclp, &ace);

/*
 *	Now, process any extra specifications from utilities/access-template
 *	Don't do anything unless the file exists.
 */

    sprintf (atname, "%s/access-template", libdir);
    if ((atfile = fopen (atname, "r")) != NULL)
    {
	int	zapindex;
	char    pline[LBUFLEN];
	while (fgets (pline, sizeof pline, atfile) != NULL)
	{
	    if (pline[0] == '#')			/* comment */
		continue;
	    zapindex = strlen (pline);
	    if (pline[zapindex] == '\n')
		pline[zapindex] = '\0';			/* zap newline */
	    if (parsemode (pline, &ace, MUST_HAVE_MODE, NOT_VERBOSE) == 0) {
	        /* worked, add it */
		acl_add(aclp, &ace);
	    }
	}
	fclose (atfile);			       /* done with template */
      }
      acl_close(aclp);
    }

    /* skip this if we didn't make an nf */
    if (Uflag || (!Qflag && modified)) 
      {
	/* update the available notes list */
	sprintf (cmdline, "%s/%s", libdir, MAKEACTIVE);
	dosystem (cmdline, spooldir, NOSTR);
#ifdef MSGID_INDEX
	sprintf (cmdline, "%s/%s", libdir, MAKEINDEX);
	dosystem (cmdline, nfname, NOSTR);
#endif /* MSGID_INDEX */
      }
    exit (GOOD);
}

usage(invokedas)
char *invokedas;
{
	printf ("Usage: %s [-aonqu] topic1 [...]\n", invokedas);
	printf ("\t-a = enable anonymous postings\n");
	printf ("\t-o = open the new notesfile(s)\n");
	printf ("\t-n = enable networking for this notesfile\n");
	printf ("\t-q = quick (don't rebuild active)\n");
	printf ("\t-u = update active (rebuild it regardless)\n");
}

