/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/loadem.c,v 2.0 89/04/15 23:56:22 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include "header.h"
#include "acl.h"

/*
 *	load a file of generic notes.
 *	This routine will read the file supplied (as an fid)   
 *	and place it into the notefile.
 *	locking is supressed if the lockit flag is false
 *	uids are mapped to zero if the system that the note came from
 *	does not match the local system.
 *
 *	N.B.: This routine now exists strictly for backwards
 *	compatability
 */

enum headertype {
	File,
	Note,
	Response,
	Permissions,
	NF_Title,
	NF_Director_Message,
	NF_Last_Modified,
	NF_Status,
	NF_Id_Sequence,
	NF_Number,
	NF_Last_Transmit,
	NF_Created,
	NF_Last_Used,
	NF_Days_Used,
	NF_Notes_Written,
	NF_Notes_Read,
	NF_Notes_Transmitted,
	NF_Notes_Received,
	NF_Notes_Dropped,
	NF_Responses_Written,
	NF_Responses_Read,
	NF_Responses_Transmitted,
	NF_Responses_Received,
	NF_Responses_Dropped,
	NF_Entries,
	NF_Walltime,
	NF_Orphans_Received,
	NF_Orphans_Adopted,
	NF_Transmits,
	NF_Receives,
	NF_Expiration_Age,
	NF_Expiration_Action,
	NF_Expiration_Status,
	NF_Working_Set_Size,
	NF_Longest_Text,
	NF_Policy_Exists,
	NF_Descriptor,
	Access_Right,
	NF_Access_Finished,
	};

struct {
	char *h_string;
	enum headertype h_type;
	}	headers[] = {
	"F:",				File, /* A Notes 1.7 header line */
	"N:",				Note,
	"R:",				Response,
	"P:",				Permissions,
	"NF-Title:",			NF_Title,
	"NF-Director-Message:",		NF_Director_Message,
	"NF-Last-Modified:",		NF_Last_Modified,
	"NF-Status:",			NF_Status,
	"NF-Id-Sequence:",		NF_Id_Sequence,
	"NF-Number:",			NF_Number,
	"NF-Last-Transmit:",		NF_Last_Transmit,
	"NF-Created:",			NF_Created,
	"NF-Last-Used:",		NF_Last_Used,
	"NF-Days-Used:",		NF_Days_Used,
	"NF-Notes-Read:",		NF_Notes_Read,
	"NF-Notes-Transmitted:",	NF_Notes_Transmitted,
	"NF-Notes-Written:",		NF_Notes_Written,
	"NF-Notes-Received:",		NF_Notes_Received,
	"NF-Notes-Dropped:",		NF_Notes_Dropped,
	"NF-Responses-Written:",	NF_Responses_Written,
	"NF-Responses-Read:",		NF_Responses_Read,
	"NF-Responses-Transmitted:",	NF_Responses_Transmitted,
	"NF-Responses-Received:",	NF_Responses_Received,
	"NF-Responses-Dropped:",	NF_Responses_Dropped,
	"NF-Entries:",			NF_Entries,
	"NF-Walltime:",			NF_Walltime,
	"NF-Orphans-Received:",		NF_Orphans_Received,
	"NF-Orphans-Adopted:",		NF_Orphans_Adopted,
	"NF-Transmits:",		NF_Transmits,
	"NF-Receives:",			NF_Receives,
	"NF-Expiration-Age:",		NF_Expiration_Age,
	"NF-Expiration-Action:",	NF_Expiration_Action,
	"NF-Expiration-Status:",	NF_Expiration_Status,
	"NF-Working-Set-Size:",		NF_Working_Set_Size,
	"NF-Longest-Text:",		NF_Longest_Text,
	"NF-Policy-Exists:",		NF_Policy_Exists,
	"NF-Descriptor:",		NF_Descriptor,
	"Access-Right:",		Access_Right,
	"NF-Access-Finished:",		NF_Access_Finished,
	(char *) 0,			(enum headertype) 0,
	};


loadem(io, infile, lockit, whofrom, extensive, trust)
	struct io_f *io;
	FILE *infile;
	int lockit;
	char *whofrom;		/* where these notes are being loaded from */
	int extensive;
	int trust;
{
	struct note_f note;
	struct note_f note2;	/* scratch for chknote */
	char line[CMDLEN];
	int i, posit;
	long count;
	char *p, *q;
	FILE *f;
	char fn[WDLEN];
	struct perm_f pe;
	char nid_sys[SYSSZ], nid_uniq[IDSZ];
	char rid_sys[SYSSZ], rid_uniq[IDSZ];
	struct msg_f mesg;
	struct hbuf h;
	extern char *index();
#ifdef __STDC__
	extern long puttrec(struct io_f*, FILE*, struct daddr_f*, long);
#else
	extern long puttrec();
#endif
	int did_ok = GOOD;	/* Our return is used as arg to exit() */

	int policy;
	FILE *accessfile;
	accessfile = NULL;

	while (sukline(infile, line)) {
		for (i = 0; headers[i].h_string; i++)
			if (strncmp(line, headers[i].h_string,
			    strlen(headers[i].h_string)) == 0)
				break;
		if (headers[i].h_string == (char *) 0) {
			log (
			"loadem: unknown header: \"%s\" in group %s from %s",
			line, io->nf, whofrom);
			did_ok = BADFORMAT;
			continue;
		}
		switch (headers[i].h_type) {
		case NF_Title :
			/*
			** may be different from one in argv -- ignore
			*/
			break;

		case NF_Director_Message :
			if (extensive == 0)
				break;
			lock(io, 'n');
			getdscr(io, &io->descr);
			p = line + strlen(headers[i].h_string);
			while (*p && ((*p == ' ') || (*p == '\t')))
				p++;
			strcpy(io->descr.d_drmes, p);
			putdscr(io, &io->descr);
			unlock(io, 'n');
			break;

		case NF_Last_Modified :	/* ignore */
			break;

		case NF_Status :
			if (extensive == 0)
				break;
			lock(io, 'n');
			getdscr(io, &io->descr);
			io->descr.d_stat &= ~OPEN;
			io->descr.d_stat &= ~ANONOK;
			io->descr.d_stat &= ~NETWRKD;

			p = line + strlen(headers[i].h_string);
			while (*p) {
				while (*p && ((*p == ' ') ||
				    (*p == '\t')))
					p++;
				if (strncmp(p, "Open", 4) == 0)
					io->descr.d_stat |= OPEN;
				if (strncmp(p, "Anonymous", 9) == 0)
					io->descr.d_stat |= ANONOK;
				if (strncmp(p, "Networked", 9) == 0)
					io->descr.d_stat |= NETWRKD;
				while (*p && (*p != ' ') &&
				    (*p != '\t'))
					p++;
			}
			putdscr(io, &io->descr);
			unlock(io, 'n');
			break;

		case NF_Id_Sequence :	/* ignore */
		case NF_Number :	/* ignore */
		case NF_Last_Transmit :	/* ignore */
		case NF_Created :	/* ignore */
		case NF_Last_Used :	/* ignore */
		case NF_Days_Used :	/* ignore */
		case NF_Notes_Written :	/* ignore */
		case NF_Notes_Read :	/* ignore */
		case NF_Notes_Transmitted :	/* ignore */
		case NF_Notes_Received :	/* ignore */
		case NF_Notes_Dropped :	/* ignore */
		case NF_Responses_Written :	/* ignore */
		case NF_Responses_Read :	/* ignore */
		case NF_Responses_Transmitted :	/* ignore */
		case NF_Responses_Received :	/* ignore */
		case NF_Responses_Dropped :	/* ignore */
		case NF_Entries :	/* ignore */
		case NF_Walltime :	/* ignore */
		case NF_Orphans_Received :	/* ignore */
		case NF_Orphans_Adopted :	/* ignore */
		case NF_Transmits :	/* ignore */
		case NF_Receives :	/* ignore */
		case NF_Expiration_Age :	/* ignore */
		case NF_Expiration_Action :	/* ignore */
		case NF_Expiration_Status :	/* ignore */
		case NF_Working_Set_Size :	/* ignore */
		case NF_Longest_Text :	/* ignore */
			break;

		case NF_Policy_Exists :
			p = line + strlen(headers[i].h_string);
			while (*p && ((*p == ' ') || (*p == '\t')))
				p++;
			if (strncmp(p, "Yes", 3) == 0)
				policy = POLICY;
			else
				policy = NOPOLICY;
			break;

		case NF_Descriptor :
			break;

		case Access_Right :
			if (extensive == 0)
				break;
			if (accessfile == NULL) {
				sprintf(fn, "%s/%s/%s", spooldir,
				    mapnfname( io->nf), ACCESS);
				if ((accessfile = fopen(fn, "w")) == 
				    NULL) {
					perror(io->nf);
					break;
				}
			}

			p = line + strlen(headers[i].h_string);
			while (*p && ((*p == ' ') || (*p == '\t')))
				p++;

			pe.ptype = PERMUSER;
			while (*p && *p != ':')
				switch (*p++) {
				case 'U':
					pe.ptype = PERMUSER;
					break;
				case 'G':
					pe.ptype = PERMGROUP;
					break;
				case 'S':
					pe.ptype = PERMSYSTEM;
					break;
				}
			if (*p == ':')
				p++;

			q = pe.name;
			while (*p && *p != '=')
				*q++ = *p++;
			*q = 0;

			if (*p == '=')
				p++;

			pe.perms = 0;
			while (*p)
				switch (*p++) {
				case 'd':
					pe.perms |= DRCTOK;
					break;
				case 'r':
					pe.perms |= READOK;
					break;
				case 'w':
					pe.perms |= WRITOK;
					break;
				case 'a':
					pe.perms |= RESPOK;
					break;
				}
			if (fwrite((char *)&pe, sizeof pe, 1, accessfile) != 1)
			    perror("fwrite");
			break;

		case NF_Access_Finished :
			if (accessfile != NULL)
				fclose(accessfile);
			accessfile = NULL;
			break;

		case Permissions :
			/* permissions */
			sprintf(fn, "%s/%s/%s", spooldir, mapnfname( io->nf), ACCESS);
			if (extensive == 0 || (f = fopen(fn, "w")) == NULL) {
				perror(io->nf);
				/* ignore rest */
				while (sukline(infile, line))
					if (line[0] == 0)
						break;
				break;
			}
			while (sukline(infile, line)) {
				if (line[0] == 0)
					break;
				q = pe.name;
				p = line;
				while (*p && *p != ':')
					*q++ = *p++;
				*q = 0;
				if (*p == ':')
					p++;
				pe.ptype = PERMUSER;
				while (*p && *p != ':')
					switch (*p++) {
					case 'U':
						pe.ptype = PERMUSER;
						break;
					case 'G':
						pe.ptype = PERMGROUP;
						break;
					case 'S':
						pe.ptype = PERMSYSTEM;
						break;
					}
				if (*p == ':')
					p++;
				pe.perms = 0;
				while (*p && *p != ':')
					switch (*p++) {
					case 'D':
						pe.perms |= DRCTOK;
						break;
					case 'R':
						pe.perms |= READOK;
						break;
					case 'W':
						pe.perms |= WRITOK;
						break;
					case 'A':
						pe.perms |= RESPOK;
						break;
					}
				fwrite((char *)&pe, sizeof pe, 1, f);
			}
			fclose(f);
			break;
		case File :
			/* Notes 2.0 (HP Internal) puts the notesfile name */
			/* after this header.  A nice idea, but we are not */
			/* going to handle the 2.0 format.  If we receive */
			/* a 2.0 batch, we call it an error and punt. */
			log("loadem: rejected Notes 2.0 batch for \"%s\" from \"%s\"",
			    io->nf, whofrom);
			/* nfcomment() should  go here */
			return BADFORMAT; /* Fatal error.  Give up. */
		case Note :
			bzero((char *)&h, sizeof h);
			strcpy(h.nbuf, io->nf);
			/* base note */
			if (sscanf(line, "N:%[^:]:%[^:]:",
				nid_sys, nid_uniq) != 2) {
			    log(
		    "loadem: panic, bad note header \"%s\" in group %s from %s",
			    line, io->nf, whofrom);
			    return BADFORMAT;
			}
			/*
			 * if the note was previously gatewayed from news
			 * to notes the id has been trashed.  It is now
			 * -<id>xx (xx is 00 or 01 as far as I can tell). WRU
			 */
#ifdef notdef
			if ((*nid_uniq == '-') && (strlen(nid_uniq) > 3)) {
				nid_uniq[strlen(nid_uniq) - 2] = '\0';
				buildid(h.ident, &nid_uniq[1], nid_sys);
			} else
				buildid(h.ident, nid_uniq, nid_sys);
#endif
			fixnotesid(h.ident, nid_uniq, nid_sys);

			/* get notes title, strip trailing blanks */
			sukline(infile, line);
			safecpy(note.n_title, line, TITLEN);
			p = note.n_title + strlen(note.n_title);
			while (--p >= note.n_title && *p == ' ')
				*p = 0;

			/*
			 * note's author
			 * if the system name is there, pass string in tact
			 * otherwise construct author name.
			 */
			sukline(infile, line);
			sscanf(line, "%[^:]:", h.from);
			if (index(h.from, '@') == 0) {
				sprintf(line, "%s@%s", h.from, nid_sys);
				strcpy(h.from, line);
			}

			sukline(infile, line);		/* time of writing */
			timein(line, &h.subtime);

			if (extensive) {
				sukline(infile, line);
				timein(line, &h.rectime);
				sukline(infile, line);
				timein(line, &note.n_lmod);
				sukline(infile, line);
			} else {
				/* set up who came from */
				time(&h.rectime);
				strcpy(line, whofrom);
			}
			/* set up path (backwards compatable) */
			if (index(line, '!') == 0) {
				if (strcmp(line, nid_sys))
					sprintf(h.path, "%s!%s!%s", line,
					    nid_sys, h.from);
				else
					sprintf(h.path, "%s!%s", nid_sys, h.from);
			} else
				safecpy(h.path, line, PATHLEN);
			if (p = rindex(h.path, '@'))
				*p = 0;

			sukline(infile, line);			/* status */
			sscanf(line, "%o:%ld", &note.n_msg.m_stat, &count);

			if (extensive == 0) {
				getperms(io, 1, nid_sys);
				/* find out if permitted */
				if (allow(io, WRITOK) == 0) {
					/* count it as dropped */
					log("loadem: %s: sys not permitted", h.ident);
					io->nnotdrop++;
					break;
				}
			}
			if (lockit)
				lock(io, 'n');
			if (trust == NODETAIL)
				posit = chknote(io, h.ident, &note2);
			else
				posit = 0;
			/* see if here */
			if (posit == 0) {
				/* read text */
				puthdr(io, &note.n_msg, &h);
				puttrec(io, infile, &note.n_msg.m_addr, count);
				/* set posit for any following responses */
				posit = putnote(io, &note, policy,
				    extensive == DETAIL ? NOADDTIME : ADDTIME);
				policy = NOPOLICY;
				if (verbose_log)
				    log("loadem: %s: note received", h.ident);
				/* count as a recieved */
				io->nnotrcvd++;	
				if (lockit)
					unlock(io, 'n');
				break;
			}
			if ((note2.n_stat&ORPHND) &&
			    (note.n_stat&ORPHND) == 0) {
				/* extant is orphan, new isn't */
				puthdr(io, &note.n_msg, &h);
				puttrec(io, infile, &note.n_msg.m_addr, count);
				safecpy(note2.n_title, note.n_title, TITLEN);
				note2.n_msg = note.n_msg;
				note2.n_lmod = h.rectime;
				putnrec(io, posit, &note2);
#ifdef MSGID_INDEX
				putmsgid(io, posit, 0, &note2.n_msg);
#endif /* MSGID_INDEX */				
				if (verbose_log)
				    log("loadem: %s: orphan replaced", h.ident);
				/* and replace */
			} else {
				/* skip text */
				for (i = 0; i < count; i++)
					getc(infile);
				if (verbose_log)
				    log("loadem: %s: duplicate note", h.ident); 
				/* count as dropped */
				io->nnotdrop++;	
			}
			if (lockit)
				unlock(io, 'n');

			break;

		case Response :
			bzero((char *)&h, sizeof h);
			strcpy(h.nbuf, io->nf);
			/* response */
			if (sscanf(line, "R:%[^:]:%[^:]:%[^:]:%[^:]:",
				nid_sys, nid_uniq, rid_sys, rid_uniq) != 4) {
			    log(
	    "loadem: panic, bad response header \"%s\" in group %s from %s",
			    line, io->nf, whofrom);
			    return BADFORMAT; /* Fatal error.  Give up. */
			}
			/*
			 * clean up news->notes id trashing (see code
			 * in Notes above for explanation).  WRU
			 */
#ifdef notdef
			if ((*nid_uniq == '-') && (strlen(nid_uniq) > 3)) {
				nid_uniq[strlen(nid_uniq) - 2] = '\0';
				buildid(h.followid, &nid_uniq[1], nid_sys);
			} else
				buildid(h.followid, nid_uniq, nid_sys);
			if ((*rid_uniq == '-') && (strlen(rid_uniq) > 3)) {
				rid_uniq[strlen(rid_uniq) - 2] = '\0';
				buildid(h.ident, &rid_uniq[1], rid_sys);
			} else
				buildid(h.ident, rid_uniq, rid_sys);
#endif
			fixnotesid(h.followid, nid_uniq, nid_sys);
			fixnotesid(h.ident,    rid_uniq, rid_sys);

			/* response's author */
			sukline(infile, line);
			sscanf(line, "%[^:]:", h.from);
			if (index(h.from, '@') == 0) {
				sprintf(line, "%s@%s", h.from, rid_sys);
				strcpy(h.from, line);
			}

			/* time of writing */
			sukline(infile, line);
			timein(line, &h.subtime);

			if (extensive) {
				sukline(infile, line);
				timein(line, &h.rectime);
				sukline(infile, line);
			} else {
				/* set correct source */
				time(&h.rectime);
				strcpy(line, whofrom);	
			}

			/* set up path (backwards compatable) */
			if (index(line, '!') == 0) {
				if (strcmp(line, rid_sys))
					sprintf(h.path, "%s!%s!%s", line,
					    rid_sys, h.from);
				else
					sprintf(h.path, "%s!%s", rid_sys, h.from);
			} else
				safecpy(h.path, line, PATHLEN);
			if (p = rindex(h.path, '@'))
				*p = 0;

			sukline(infile, line);			/* status */
			sscanf(line, "%o:%ld", &mesg.m_stat, &count);

			if (lockit)
				lock(io, 'n');
			/* find the basenote unless we know it is in order */
			if (trust == NODETAIL)
				posit = chknote(io, h.followid, &note);
			/* see if note is here */
			if (posit == 0) {
				struct hbuf hfake;

				bzero((char *)&hfake, sizeof hfake);
				/* build us a fake note */
				note.n_nresp = 0;
				/* this note is base of an orphan */
				strcpy(hfake.ident, h.followid);
				sprintf(note.n_title, "Response to %s", h.followid);
				note.n_stat = ORPHND;
				sprintf(hfake.from, "Unknown@%s", nid_sys);
				strcpy(hfake.nbuf, io->nf);
				sprintf(hfake.from, "%s!Unknown", nid_sys);
				hfake.subtime = h.subtime;
				hfake.rectime = h.rectime;
				note.n_msg.m_addr.addr = 0;
				puthdr(io, &note.n_msg, &hfake);
				posit = putnote(io, &note, NOPOLICY, ADDTIME);
				/* enter it */
				/* bump count of recieved orphans */
				if (verbose_log)
				    log("loadem: %s: orphan %s created", h.ident, h.followid);
				io->norphans++;
			}
			if ((trust == DETAIL) ||
			    (chkresp(io, h.ident, &note, posit) == 0)) {
				if (extensive == 0) {
					/* grab systems permissions */
					getperms(io, 1, rid_sys);
				}
				if (extensive || allow(io, RESPOK)) {
					puthdr(io, &mesg, &h);
					puttrec(io, infile, &mesg.m_addr, count);
					putresp(io, posit, &note, &mesg,
					    extensive == NODETAIL);
					/* he is a rcvd ! */
					if (verbose_log)
					    log("loadem -t: %s: response received", h.ident);
					io->nrsprcvd++;	
				} else {
					/* count non-permitted as dropped */
					io->nrspdrop++; 
					/* skip text */
					for (i = 0; i < count; i++)
						getc(infile);	
					log("loadem: %s: response denied", h.ident);
				}
			} else {
				io->nrspdrop++;
				/* skip text */
				for (i = 0; i < count; i++)
					getc(infile);
				if (verbose_log)
				    log("loadem: %s: duplicate response", h.ident);
			}
			if (lockit)
				unlock(io, 'n');
			break;

		default: 
			x(-1, "loadem: bad generic file");
			break;
		}
	}
	if (accessfile != NULL)
		fclose(accessfile);

	return did_ok;
}
