/* $Header: times.c,v 1.3 87/01/17 21:01:09 notes Exp $ */

/*
 * Routines to manage the sequencer
 *
 *	Lou Salkind
 *	New York University
 */

#include "parms.h"
#include "structs.h"

#define MAX_BETWEEN_WRITES 500	/* controls checkpointing in saveseq() */

extern int errno;
long lseek();
struct nfile *getnfile();
time_t cgtdate();
char *index();

/*
 * Read the sequencer file and set last read times.
 *
 * Lines are in the form
 *	notesfile: date-string
 */
readseq(name, ignseq)
	char *name;
	int ignseq;
{
	register struct nfile *np;
	char buf[BUFLEN];
	char *p;
	FILE *f;

	if ((f = fopen(name, "r")) == NULL)
		return;
	while (fgets(buf, sizeof buf, f)) {
		p = index(buf, ':');
		if (p == 0)
			continue;
		*p++ = 0;
		np = getnfile(buf);
		if (np && np->n_lookat && (ignseq || np->n_seqtyp)) {
			np->n_when = cgtdate(p);
			if (np->n_when < 0)
				np->n_when = 0;
		}
	}
	fclose(f);
}

doseqread()
{
	register struct nfile *np;

	for (np = nfile; np; np = np->n_next)
		if (np->n_lookat && np->n_seqtyp)
			return(1);
	return(0);
}

static int num_updated;

updseq(name, wdate)
	char *name;
	time_t wdate;
{
	register struct nfile *np;

	np = getnfile(name);
	if (np == 0)
		return;
	np->n_when = wdate;
	np->n_seqtyp = UPDSEQ;
	num_updated++;
}

doseqwrite()
{
	return(num_updated);
}


/*
 *  saveseq() -- write out the sequencer if it has been too long.
 *     Helps those poor folk on the other end of modems (SIGHUP death).
 *
 *   w underwood, oct 1986
 */
saveseq(name)
     char *name;
{
  static long last_written = 0;
  long now;
     
  time(&now);

  if (last_written == 0)	/* first time we are called */
    {
      last_written = now;
      return 0;			/* No write. */
    }

  if (doseqwrite() && now - last_written > MAX_BETWEEN_WRITES)
    {
      ignsigs++;
      writeseq(name);
      ignsigs--;
      last_written = now;
      return 1;			/* We did a write. */
    }
  return 0;			/* No write. */
}


/*
 * Write the sequencer file and set last read times.
 */
writeseq(name)
	char *name;
{
	register struct nfile *np;
	FILE *fo, *fi;
	char ntmp[WDLEN];
	char buf[BUFLEN];
	char *p;

	if (doseqwrite() == 0)
		return;
	sprintf(ntmp, "%s.tmp", name);
	fo = fopen(ntmp, "w");
	if (fo == NULL) {
		int e;
		
		e = errno;
		fprintf (stderr,
		    "writeseq: can't open sequencer tmp file \"%s\" for writing - ",
		    ntmp);
		errno = e;
		perror("");
		return;
	}
	/* update those groups we touched this session */
	for (np = nfile; np; np = np->n_next)
		if (np->n_seqtyp == UPDSEQ)
			fprintf(fo, "%s: %s\n", np->n_name, arpadate(&np->n_when));
	/* copy any other lines from old sequncer */
	fi = fopen(name, "r");
	if (fi) {
		while (fgets(buf, sizeof(buf), fi)) {
			p = index(buf, ':');
			if (p == 0) 
				continue;	/* bad formats ignored */
			*p = 0;
			np = getnfile(buf);
			if (np && np->n_seqtyp == UPDSEQ)
				continue;	/* did it above */
			*p = ':';
			fputs(buf, fo);
		}
		fclose(fi);
	}
	fclose(fo);
	x(rename(ntmp, name) < 0,
	    "writeseq: can't rename sequencer tmp file from \"%s\" to \"%s\"",
	    ntmp, name);
	num_updated = 0;
}
