#include <sys/file.h>

#ifndef __STRING_POOL__
#include "stringpool.h"
#endif

#ifndef L_SET
#  define L_SET 0
typedef long off_t;
#endif L_SET

sp_t
sp_open(io)
    struct io_f *io;
{
    sp_t sp;

    x(((sp.fd = open(io->str_pool_fn, O_RDWR|O_CREAT, 0664)) < 0),
      "sp_open: cannot open string pool file '%s'", io->str_pool_fn);
    sp.io = io;

    lock(io, 'n');	/* May want a separate lock for string pool */

    return sp;
}

int
sp_close(sp)
    sp_t sp;
{
    unlock(sp.io, 'n');
    return close(sp.fd);
}

void
sp_get_string(sp, dest, which, limit)
    sp_t sp;
    char *dest;
    int which, limit;
{
    int nread;
    char buf[SP_STR_LEN];

    x(sp.fd < 0, "sp_get_string(which=%d): string pool not open", which);

    x(lseek(sp.fd, (off_t)(which * SP_STR_LEN), L_SET) < 0,
      "sp_get_string(which=%d): cannot lseek on string pool", which);

    x((nread = read(sp.fd, buf, SP_STR_LEN)) < SP_STR_LEN && nread != 0,
      "sp_get_string(which=%d): cannot read whole string from pool", which);

    if (nread == 0) {
	bzero(buf, SP_STR_LEN);
    }

    safecpy(dest, buf, limit);

}

void
sp_put_string(sp, buf, which)
    sp_t sp;
    char *buf;
    int which;
{
    int nread;

    x(sp.fd < 0, "sp_put_string(which=%d): string pool not open", which);

    x(lseek(sp.fd, (off_t)(which * SP_STR_LEN), L_SET) < 0,
      "sp_get_string(which=%d): cannot lseek on string pool", which);

    x(write(sp.fd, buf, SP_STR_LEN) < SP_STR_LEN,
      "sp_get_string(which=%d): cannot write whole string from pool", which);

}
