/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/preptxt.c,v 2.0 89/04/16 01:06:37 gore Exp $ */

#include "parms.h"
#include "structs.h"

/*
 *	preptxt(fid, author, date, atext)
 *	put the standard headers and text into the specified file
 */
preptxt(io, zfile, msgp)
	struct io_f *io;
	FILE *zfile;
	struct msg_f *msgp;
{
	char buf[BUFLEN];
	int linecount;

	/* dump the header */
	gethdr(io, msgp, msgp->m_from, buf);
	if (concise_quotes) {
	    fprintf(zfile, "/ %s / %s", io->nf, buf);
	    sprdateonly(msgp->m_subtime, buf);
	} else {
	    fprintf(zfile, "/ %s:%s / %s", full_hostname, io->nf, buf);
	    sprdate(msgp->m_subtime, buf);
	}
	fprintf(zfile, " / %s /\n", buf);
	linecount = 1;

	/* write the file */
	linecount += pageout(io, &msgp->m_addr, zfile);

	/* dump the trailer */
	fprintf(zfile, "----------\n");
	linecount++;

	return(linecount);
}
