#include "parms.h"
#include "structs.h"
#include "macros.h"
#include "acl.h"

/*
 *	parsemode
 *
 *	Parse the supplied (character string) access specification
 *	into the specified perm_f structure.
 *
 *	The syntax is of the parameter is:   Category:Name=Modestring
 *	where
 *	  Category is one of (case-insensitive):
 *	    u  -- user
 *	    g  -- group
 *	    s  -- system
 *	  Name is the name of the user, group or system (case-sensitive [why?])
 *	  Modestring consists of a combination of (case-insensitive):
 *	    d  -- director
 *	    r  -- read
 *	    w  -- write
 *	    a  -- answer
 *	    n  -- none
 *
 *	Ray Essick
 */

parsemode (asciimode, pstuff, must_have_mode, verbose)
    char *asciimode;
    struct perm_f *pstuff;
    int	must_have_mode;
    int verbose;
{
    char   *p;
    char    name[WDLEN];				/* hold the name */
    char    namespec[WDLEN];				/* entire name */
    int     nametype;					/* name class */
    char    mode[WDLEN];				/* and the mode */
    char    imode = 0;					/* internalized */

    if ((p = index (asciimode, '=')) == NULL) {		/* find the mode */
	if (must_have_mode) {
	    if (verbose) {
		printf ("No mode separator: %s\n", asciimode);
	    }
	    return (1);
	} else {
	    mode[0] = '\0';
	    strcpy (namespec, asciimode);
	}

    } else {

	*p++ = '\0';				/* split out mode */
	strcpy (mode, p);			/* grab mode */
	strcpy (namespec, asciimode);		/* and name */
	*--p = '=';				/* replace marker */
    }

    if ((p = index (namespec, ':')) == NULL)		/* implicitly user? */
    {
	strcpy (name, namespec);			/* user name */
	nametype = PERMUSER;				/* default to user */
    }
    else
    {
	*p++ = '\0';				     /* break specification */
	strcpy (name, p);			     /* load name */
	switch (namespec[0])			     /* determine class */
	{
	    case 'u': 
	    case 'U': 
		nametype = PERMUSER;
		break;

	    case 'g': 
	    case 'G': 
		nametype = PERMGROUP;
		break;

	    case 's': 
	    case 'S': 
		nametype = PERMSYSTEM;
		break;

	    default: 
		if (verbose)
		    printf ("Invalid name class: %s\n", namespec);
		return (1);
		break;
	}

    }

#ifndef notdef
/*
 * We don't care that much if the stuff is "bogus", especially when deleting
 * it.  Maybe there should be a separate command/option to verify an acl?
 */
#else /* !notdef */
/*
 *	Check that user/group are defined on our system. Don't
 *	want to be filling our tables with bogus stuff.
 */

    switch (nametype)
    {
	case PERMUSER: 
	    if (getpwnam (name) == NULL)		/* does he exist? */
	    {
		if (verbose)
		    printf ("%s: no such user\n", name);
		return (1);
	    }
	    break;

	case PERMGROUP: 
	    if (getgrnam (name) == NULL)		/* does it exist */
	    {
		if (verbose)
		    printf ("%s: no such group\n", name);
		return (1);
	    }
	    break;

	case PERMSYSTEM: 
	default: 
	    break;
    }
#endif notdef

/*
 *	Now internalize the mode
 */

    imode = 0;					     /* initially null */
    for (p = mode; *p; p++)			     /* each specifier */
    {
	switch (forcelower(*p))
	{

	    case 'd': 				     /* director */
		imode = DRCTOK | READOK | WRITOK | RESPOK;
		break;

	    case 'r': 				     /* read */
		imode |= READOK;
		break;

	    case 'w': 				     /* write (and respond) */
		imode |= WRITOK | RESPOK;
		break;

	    case 'a': 				     /* respond */
		imode |= RESPOK;
		break;

	    case 'n': 				     /* nullify */
		imode = 0;
		break;

	    default: 
		if (verbose)
		    printf ("%c: Invalid permission mode\n", *p);
		break;
	}

    }
    pstuff -> ptype = nametype;				/* load structure */
    pstuff -> perms = imode;
    strcpy (pstuff -> name, name);
    return 0;
}
