/* $Header: pagein.c,v 1.1 85/12/20 16:52:30 notes Exp $ */

/*
 * Routines to handle the text file
 */

#include "parms.h"
#include "structs.h"

static long t_startpos;

/*
 * start a text stream
 * we assume the note file has been locked elsewhere (if required)
 */
t_stext(io, where)
	struct io_f *io;
	struct daddr_f *where;
{
	long fseek();
	struct txthead_f txthead;

	/* get next available text slot */
	x(fseek(io->fidtxt, 0L, 0) < 0,
	    "t_stext: fseek to zero failed in text of \"%s\"",
	    io -> nf);
	x(fread((char *)where, sizeof(*where), 1, io->fidtxt) != 1,
	    "t_stext: fread at 0 in text of \"%s\" failed",
	    io -> nf);
	t_startpos = where->addr;
	x(fseek(io->fidtxt, t_startpos + sizeof(txthead), 0) < 0,
	    "t_stext: fseek in text of \"%s\" failed",
	    io -> nf);
}

/*
 * end a text stream
 */
t_etext(io, where)
	struct io_f *io;
	struct daddr_f *where;
{
	struct txthead_f txthead;
	struct daddr_f nwhere;
	long tchars;
	long fseek(), ftell();

	tchars = ftell(io->fidtxt) - t_startpos;

	/* update the message header */
	x(fseek(io->fidtxt, t_startpos, 0) < 0,
	    "e_etext: bad reseek for msg header in text of \"%s\"",
	    io -> nf);
	txthead.note_no = 0;
	txthead.resp_no = 0;
	txthead.textlen = tchars - sizeof(txthead);
	x(fwrite((char *)&txthead, sizeof(txthead), 1, io->fidtxt) != 1,
	    "e_etext: couldn't write header in text of \"%s\"", io -> nf);
	where->addr = t_startpos;

	/* update the next free location */
	x(fseek(io->fidtxt, 0L, 0) < 0,
	    "e_etext: couldn't reseek in text of \"%s\"", io -> nf);
	nwhere.addr = t_startpos + tchars + sizeof(txthead);
	if (nwhere.addr & 1)				/* odd?? */
		nwhere.addr++;			/* round to word boundary */
	x(fwrite((char *)&nwhere, sizeof(nwhere), 1, io->fidtxt) != 1,
	    "e_etext: couldn't update in text of \"%s\"", io -> nf);

	fflush(io->fidtxt);
}

/*
 * read in a note from a stdio descriptor
 */
pagein(io, zfile, where)
	struct io_f *io;
	FILE *zfile;
	struct daddr_f *where;
{
	register int c;

	t_stext(io, where);
	while ((c = getc(zfile)) != EOF)
		putc(c, io->fidtxt);
	t_etext(io, where);
}

/*
 * read in a note from a stdio descriptor,
 * counting characters
 */
puttrec(io, zfile, where, count)
	struct io_f *io;
	FILE *zfile;
	struct daddr_f *where;
	register long count;
{
	register int c;

	t_stext(io, where);
	while (count-- > 0 && (c = getc(zfile)) != EOF)
		putc(c, io->fidtxt);
	t_etext(io, where);
}

pageout(io, where, zfile)
struct io_f *io;
struct daddr_f *where;
FILE *zfile;
{
	struct txthead_f txthead;
	register int c;
	register long count;
	int lines;

	lines = 0;
	gethrec(io, where, &txthead);
	count = txthead.textlen;
	while (count-- > 0 && (c = getc(io->fidtxt)) != EOF) {
		if (c == '\n')
			lines++;
		putc(c, zfile);
	}
	return(lines);
}

/*
 * seeks and read the text record header.
 * Leaves the file pointing at the text itself.
 */
gethrec(io, where, head)
struct io_f *io;
struct daddr_f *where;
struct txthead_f *head;
{
	x(fseek(io->fidtxt, where->addr, 0) < 0,
	    "gethrec: couldn't fseek in text of \"%s\"", io -> nf);
	x(fread((char *)head, sizeof(*head), 1, io->fidtxt) != 1,
	    "gethrec: couldn't read text of \"%s\"", io -> nf);
}
