/* $Header: newsgroup.c,v 1.1 85/12/20 16:49:41 notes Exp $ */

#include "parms.h"
#include "structs.h"

/*
 *	newsgroup(ngroup, nfname)
 *
 *	This routine looks in the file specified by NEWSALIAS
 *	for a correspondence between the news group name supplied 
 *	and a notesfile name.
 *	The resultant match is placed where the second parameter points.
 *	In the event of no match, the same name is passed back.
 */

newsgroup(ngroup, nfname)
char *ngroup;
char *nfname;
{
	FILE *groups;
	char linebuf[BUFLEN];
	char *p;
	static char whitespace[] = " \t\n";
	extern char *strtok();

	strcpy(nfname, ngroup);		/* arrange for failure */

	sprintf(linebuf, "%s/%s", libdir, NEWSALIAS);
	if ((groups = fopen(linebuf, "r")) == NULL)
		return(-1);

	while (fgets(linebuf, sizeof linebuf, groups)) {
		if ((p = strtok(linebuf, whitespace)) == 0)
			continue;
		if (strcmp(p, ngroup))
			continue;
		if (p = strtok(NOSTR, whitespace)) {
			strcpy(nfname, p);	/* copy it to caller */
			fclose(groups);
			return(1);		/* success */
		}
	}
	fclose(groups);
	return(0);			/* no match */
}
