/* $Header: lock.c,v 1.8 87/09/11 12:37:14 notes Exp $ */

#include "parms.h"
#include "structs.h"
#include <sys/stat.h>
#include <errno.h>

#ifdef BSD4_2
#  include <sys/file.h>
#else
#  ifdef LOCKF
#    include <unistd.h>
#  endif
#endif

#define	LOCKTIME	300L	/* how long before lockfile is not valid */
#define	LWAIT	2		/* seconds to wait before retrying */

extern int errno;
extern char *sys_errlist[];

int ignsigs;

/*
 * lock creates a lock file, or waits until it can create the lock.
 * lock files are of the form lock#  where # is a character passed
 * to the routine.
 */
lock(io, c)
	struct io_f *io;
	int c;
{
	int i;
	int fd;			/* file descriptor */
	char lckf[WDLEN];
	struct stat sb;
	long nowtime;
	long seekp;
	extern long lseek();

	ignsigs++;

#ifdef BSD4_2
	switch (c)
	  {
	  case 'n':
	    fd = io->fidndx;
	    break;
	  case 'r':
	    fd = io->fidrdx;
	    break;
	  case 't':
	    fd = fileno(io->fidtxt);
	    break;
	  default:
	    x(1, "lock: illegal lock type = '%c' (%#o) in \"%s\"",
	      c, c, io->nf);
	  }
	
	/* No need to reset the seek pointer as this shouldn't bother it */
	x(flock(fd, LOCK_EX),
	  "lock: flock() call failed on \"%s\", type= '%c', errno= %d (%s)",
	  io->nf, c, errno, sys_errlist[errno]);

#else /*!BSD4_2*/
#  ifdef LOCKF
	switch (c)
	  {
	  case 'n':
	    fd = io->fidndx;
	    break;
	  case 'r':
	    fd = io->fidrdx;
	    break;
	  case 't':
	    fd = fileno(io->fidtxt);
	    break;
	  default:
	    x(1, "lock: illegal lock type = '%c' (%#o) in \"%s\"",
	      c, c, io->nf);
	  }
	
	seekp = lseek(fd, 0L, 1); /* save seek pointer */
	x(lseek(fd, 0L, 0),
	  "lock: lseek() call failed on \"%s\", type= '%c', errno= %d (%s)",
	  io->nf, c, errno, sys_errlist[errno]);

	x(lockf(fd, F_LOCK, 0),
	  "lock: lockf() call failed on \"%s\", type= '%c', errno= %d (%s)",
	  io->nf, c, errno, sys_errlist[errno]);
	lseek(fd, seekp, 0);	/* restore seek pointer */

#  else  /* LOCKF */	
	/*	For notes via RFA - libdir needs to be on
	**	remote user's system - lock needs to be in
	**	spooldir to be shared by all users */
	sprintf(lckf, "%s/%s/LOCK.%c", spooldir, mapnfname(io->nf), c);
	while ((i = creat(lckf, 0)) < 0) {
		i = stat(lckf, &sb);
		if (errno == ENOENT)
		  continue;	/* Locking process unlinked it.  Try again. */
		x(i < 0,
		    "lock: failed to create lockfile \"%s\", stat returned %d, errno= %d (%s)",
		    lckf, i, errno, sys_errlist[errno]);
		time(&nowtime);
		if ((nowtime - sb.st_mtime) > LOCKTIME) {
			fprintf(stderr, "Removing old lockfile %s\n", lckf);
			unlink(lckf);
			continue;
		}
		sleep(LWAIT);
	}
	close(i);
#  endif /* LOCKF */
#endif /*!BSD4_2*/
}

/*
 * unlock takes the same arguments as the lock routine, and it
 * will remove the corresponding lock file
 */
unlock(io, c)
	struct io_f *io;
	int c;
{
	char lckf[WDLEN];
	int i;
	int fd;			/* file descriptor */
	long seekp;
	extern long lseek();

#ifdef BSD4_2
	switch (c)
	  {
	  case 'n':
	    fd = io->fidndx;
	    break;
	  case 'r':
	    fd = io->fidrdx;
	    break;
	  case 't':
	    fd = fileno(io->fidtxt);
	    break;
	  default:
	    x(1, "unlock: illegal lock type = '%c' (%#o) in \"%s\"",
	      c, c, io->nf);
	  }
	
	/* No need to reset the seek pointer as this shouldn't bother it */
	x(flock(fd, LOCK_UN),
	  "unlock: flock() call failed on \"%s\", type= '%c', errno= %d (%s)",
	  io->nf, c, errno, sys_errlist[errno]);

#else /*!BSD4_2*/
#  ifdef LOCKF
	switch (c)
	  {
	  case 'n':
	    fd = io->fidndx;
	    break;
	  case 'r':
	    fd = io->fidrdx;
	    break;
	  case 't':
	    fd = fileno(io->fidtxt);
	    break;
	  default:
	    x(1, "unlock: illegal lock type = '%c' (%#o) in \"%s\"",
	      c, c, io->nf);
	  }
	
	seekp = lseek(fd, 0L, 1); /* save seek pointer */
	x(lseek(fd, 0L, 0),
	  "unlock: lseek() call failed on \"%s\", type= '%c', errno= %d (%s)",
	  io->nf, c, errno, sys_errlist[errno]);

	x(lockf(fd, F_ULOCK, 0),
	  "unlock: lockf() call failed on \"%s\", type= '%c', errno= %d (%s)",
	  io->nf, c, errno, sys_errlist[errno]);
	lseek(fd, seekp, 0);	/* restore seek pointer */

#  else  /* LOCKF */	
	/*	For notes via RFA - libdir needs to be on
	**	remote user's system - lock needs to be in
	**	spooldir to be shared by all users */
	sprintf(lckf, "%s/%s/LOCK.%c", spooldir, mapnfname(io->nf), c);
	i = unlink(lckf);
	if (errno == ENOENT)
	  /* Bad news, but not fatal. */
	  log("unlock: lock file \"%s\" disappeared!", lckf);
	else
	  x(i < 0, "unlock: can't unlink lock file \"%s\"", lckf);
#  endif /* LOCKF */
#endif /*!BSD4_2*/
	
	ignsigs--;
}

/*
 * glock creates a lock file, or waits until it can create the lock.
 * lock files are of the form lock#  where # is a character passed
 * to the routine.
 * 	This lock file is a GLOBAL lock - across all notefiles
 */
glock(c)
	int c;
{
	int i;
	char lckf[WDLEN];
	struct stat sb;
	long nowtime;

	ignsigs++;
	sprintf(lckf, "%s/%s/glock.%c", libdir, LOCKS, c);
	while ((i = creat(lckf, 0)) < 0) {
		i = stat(lckf, &sb);
		x(i < 0,
		    "glock: create failed for global lockfile \"%s\"", lckf);
		time(&nowtime);
		if ((nowtime - sb.st_mtime) > LOCKTIME) {
			fprintf(stderr, "Removing old lockfile %s\n", lckf);
			unlink(lckf);
			continue;
		}
		sleep(LWAIT);
	}
	close(i);
}

/*
 * gunlock takes the same arguements as the lock routine, and it
 * will remove the corresponding lock file
 * 	This is GLOBAL locking - across all notefiles
 */
gunlock(c)
	int c;
{
	char lckf[WDLEN];

	sprintf(lckf, "%s/%s/glock.%c", libdir, LOCKS, c);
	x(unlink(lckf) < 0,
	    "gunlock: unlink failed for global lockfile \"%s\"", lckf);
	ignsigs--;
}
