/* $Header: list.c,v 1.1 85/12/20 16:49:29 notes Exp $ */

#include <ctype.h>

/*
 * listget - parse a list of integers of the form
 *	i j k-l ...
 * return number of items parsed.  Parameters are passed
 * by reference: return a pointer to the next item in
 * the list and the range of values.
 */
listget(ptr, start, finish)
	char **ptr;
	int *start;
	int *finish;
{
	char *p = *ptr;

	while (isspace(*p) || *p == ',')	/* let commas separate */
		p++;
	if (!(isdigit(*p) || *p == '-')) {	/* bad format */
		*ptr = p;
		return(0);
	}
	*start = atoi(p++);
	while (isdigit(*p))
		p++;
	if (*p != '-') {
		*finish = *start;
		*ptr = p;
		return(1);
	}
	p++;
	if (!(isdigit(*p) || *p == '-')) {	/* bad format */
		*ptr = p;
		return(0);
	}
	*finish = atoi(p++);
	while (isdigit(*p))
		p++;
	*ptr = p;
	return(2);
}
