/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/header.c,v 2.0 89/04/15 23:53:28 gore Exp $ */

/* original version from B News 2.10.2 */

/*
 * header.c - header functions plus some other goodies
 */

#include <stdio.h>

#include "parms.h"
#include "structs.h"
#include "header.h"
#include "version.h"

static char bfr[LBUFLEN];
extern char *index();

char *hfgets();

/*
 * Read header from file fp into *hp.  If wholething is FALSE,
 * it's an incremental read, otherwise start from scratch.
 * Return (FILE *) if header okay, else NULL.
 */
FILE *
hread(hp, fp, wholething)
register struct hbuf *hp;
FILE *fp;
int wholething;
{
	register int	len;
	register int	i;

	if (wholething) {
		for(i=0;i<NUNREC;i++)
			if (hp->unrec[i] != NULL)
				free(hp->unrec[i]);
			else
				break;
		bzero((char *)hp, sizeof (*hp));
	}


	/* Check that it's a B news style header. */
	if (((hfgets(bfr, PATHLEN, fp) != NULL &&
	    *bfr >= 'A' && *bfr <= 'Z') && index(bfr, ':')))
		if (frmread(fp, hp))
			goto strip;

	/* It's not.  Try A news (begins with PROTO). */
	if (*bfr != PROTO)
		return(NULL);

	/* Read in an A news format article. */
	safecpy(hp->oident, &(bfr[1]), NAMELEN);	/* file name */
	if (!nstrip(hp->oident))
		return(NULL);
	/* Newsgroup List */
	if (hfgets(hp->nbuf, BUFLEN, fp) == NULL || !nstrip(hp->nbuf))
		return(NULL);
	ngcat(hp->nbuf);
	/* source path */
	if (hfgets(hp->path, PATHLEN, fp) == NULL || !nstrip(hp->path))
		return(NULL);
	/* date */
	if (hfgets(hp->subdate, DATELEN, fp) == NULL || !nstrip(hp->subdate))
		return(NULL);
	/* title */
	if (hfgets(hp->title, BUFLEN, fp) == NULL || !nstrip(hp->title))
		return(NULL);

strip:	/* strip off sys! from front of path. */
	strcpy(bfr, hostname_in_path);
	if (strncmp(bfr, hp->path, (len = strlen(bfr))) == 0
	&& index(NETCHRS, hp->path[len]))
		strcpy(hp->path, &(hp->path[len+1]));

	/* Intuit the From: line if only a path was given. */
	if (wholething && hp->from[0] == '\0')
		intuitfrom(hp);

	/* Get old and new style message ID's. */
	if (wholething)
		fixid(hp);

	return(fp);
}


/*
 * Get header info from mail-format file.
 * Return non-zero on success.
 */
#include <ctype.h>
#define FROM 		1
#define NEWSGROUP 	2
#define TITLE 		3
#define SUBMIT		4
#define RECEIVE		5
#define EXPIRE		6
#define ARTICLEID	7
#define MESSAGEID	8
#define REPLYTO		9
#define FOLLOWID	10
#define CONTROL		11
#define SENDER		12
#define FOLLOWTO	13
#define PATH		14
#define POSTVERSION	15
#define RELAYVERSION	16
#define DISTRIBUTION	17
#define ORGANIZATION	18
#define NUMLINES	19
#define KEYWORDS	20
#define APPROVED	21
#define NFID		22
#define NFFROM		23
#define OTHER		99

char *malloc();

frmread(fp, hp)
register FILE *fp;
register struct hbuf *hp;
{
	int	unreccnt = 0;
	register int	i;
	long	curpos;
	int hdrlineno = 0;

	i = type(bfr);
	do {
		curpos = ftell(fp);
		hdrlineno++;
		switch (i) {
		case PATH:
			getfield(bfr,hp->path,PATHLEN);
			break;
		case FROM:
			getfield(bfr,hp->from,BUFLEN);
			break;
		case NEWSGROUP:
			getfield(bfr,hp->nbuf,BUFLEN);
			break;
		case TITLE:
			getfield(bfr,hp->title,BUFLEN);
			break;
		case SUBMIT:
			getfield(bfr,hp->subdate,DATELEN);
			break;
		case RECEIVE:
			getfield(bfr,hp->recdate,DATELEN);
			break;
		case EXPIRE:
			getfield(bfr,hp->expdate,DATELEN);
			break;
		case ARTICLEID:
			getfield(bfr,hp->oident,BUFLEN);
			break;
		case MESSAGEID:
			getfield(bfr,hp->ident,BUFLEN);
			break;
		case REPLYTO:
			getfield(bfr,hp->replyto,BUFLEN);
			break;
		case FOLLOWID:
			getfield(bfr,hp->followid,BUFLEN);
			break;
		case SENDER:
			getfield(bfr,hp->sender,BUFLEN);
			break;
		case FOLLOWTO:
			getfield(bfr,hp->followto,BUFLEN);
			break;
		case CONTROL:
			getfield(bfr,hp->ctlmsg,PATHLEN);
			break;
		case POSTVERSION:
			getfield(bfr,hp->postversion,BUFLEN);
			break;
		case DISTRIBUTION:
			getfield(bfr,hp->distribution,BUFLEN);
			break;
		case ORGANIZATION:
			getfield(bfr,hp->organization,BUFLEN);
			break;
		case NUMLINES:
			getfield(bfr,hp->numlines,8);
			hp->intnumlines = atoi(hp->numlines);
			break;
		case KEYWORDS:
			getfield(bfr,hp->keywords,BUFLEN);
			break;
		case APPROVED:
			getfield(bfr,hp->approved,BUFLEN);
			break;
		case NFID:
			getfield(bfr,hp->nf_id,BUFLEN);
			break;
		case NFFROM:
			getfield(bfr,hp->nf_from,BUFLEN);
			break;
		case RELAYVERSION:
			/*
			 * Only believe a relay version if it's the first
			 * line, otherwise it probably got passed through
			 * by some old neighbor.
			 */
			if (hdrlineno == 1) {
				getfield(bfr,hp->relayversion,BUFLEN);
			}
			break;
		case OTHER:
			if (unreccnt < NUNREC) {
				if ((hp->unrec[unreccnt] = malloc((unsigned)(strlen(bfr) + 1))) != NULL ) {
					strcpy(hp->unrec[unreccnt], bfr);
					unreccnt++;
				} else
					x(1, "frmread: out of memory");
			}
			break;
		}
	} while ((i = type(hfgets(bfr, LBUFLEN, fp))) > 0);

	if (*bfr != '\n')
		fseek(fp, curpos, 0);
	if ((hp->from[0] || hp->path[0]) && hp->subdate[0] && (hp->ident[0] || hp->oident[0]))
		return TRUE;
	return FALSE;
}

/*
 * There was no From: line in the message (because it was generated by
 * an old news program).  Guess what it should have been and create it.
 */
intuitfrom(hp)
register struct hbuf *hp;
{
	char *tp;
	char *user, *host, *fullname;
#ifdef __STDC__
	char *tailpath(struct hbuf*);
#else
	char *tailpath();
#endif
	char *rindex();
	char *at, *dot;

	tp = tailpath(hp);
	user = rindex(tp, '!');
	if (user == NULL)
		user = tp;
	else
		*user++ = '\0';

	/* Check for an existing Internet address on the end. */
	at = index(user, '@');
	if (at) {
		dot = index(at, '.');
		if (dot) {
			strcpy(hp->from, user);
			return;
		}
		/* @ signs are illegal except for the biggie, so */
		*at = '%';
	}

	if (tp[0] == '.')
		host = index(tp, '!') + 1;
	else if (user == tp)
		host = full_hostname;
	else
		host = tp;

	tp = index(host, '@');
	if (tp != NULL)
		*tp = 0;
	/*
	 * At this day and age of internets and screwed up mailers,
	 * assuming that the host is in your own domain is futile.
	 * It's better to leave the invalid address there for the user
	 * to see.
	 */
	sprintf(hp->from, "%s@%s", user, host);

	fullname = index(hp->path, '(');
	if (fullname != NULL) {
		fullname--;
		strcat(hp->from, fullname);
		*fullname = 0;
	}
}

/*
 * If the message has only one of ident/oident, guess what
 * the other one should be and fill them both in.
 */
fixid(hp)
register struct hbuf *hp;
{
	char lbuf[IDSZ];
	register char *p;
#ifdef OLD
	register char *q;
#endif OLD

	if (hp->ident[0] == '\0' && hp->oident[0] != '\0') {
		safecpy(lbuf, hp->oident, sizeof(lbuf));
		p = index(lbuf, '.');
		if (p == NULL) {
			strcpy(hp->ident, hp->oident);
			return;
		}
		*p++ = '\0';
		/*
		 * It may seem strange that we hardwire ".UUCP" in
		 * here instead of "mydomain".  However, we are trying
		 * to guess what the domain was on the posting system,
		 * not the local system.  Since we don't really know
		 * what the posting system does, we just go with the
		 * majority - almost everyone will be a .UUCP if they
		 * didn't fill in their Message-ID.
		 */
		sprintf(hp->ident, "<%s@%s%s>", p, lbuf, ".UUCP");
	}

#ifdef OLD
	if (hp->oident[0] == '\0' && hp->ident[0] != '\0') {
		strcpy(lbuf, hp->ident);
		p = index(lbuf, '@');
		if (p == 0) {
			strcpy(hp->oident, hp->ident);
			return;
		}
		*p++ = '\0';
		q = index(p, '.');
		if (q == NULL)
			q = index(p, '>');
		if (q)
			*q++ = '\0';
		p[SNLN] = '\0';
		sprintf(hp->oident, "%s.%s", p, lbuf+1);
	}
#endif /*OLD*/
}
