/*
 * Control message handling code.  Deal with messages which are to be
 * acted on by netnews itself rather than by people.
 *
 * Ripped off from B news 2.10.2 by Tw Cook 1 December 1985
 *
 * See defs.h "NEWS_VERSION" for the real version of netnews.
 */

#ifndef lint
#ifdef	RCSIDENT
static char rcsid[]="$Header: /g1/users/staff/gore/exp/notes/src/RCS/docontrol.c,v 2.0 89/04/15 23:46:32 gore Exp $";
static char	*SccsId = "@(#)control.c	2.30	9/12/84";
#endif	RCSIDENT
#endif !lint

#include "parms.h"
#include "structs.h"
#include "header.h"
#include "version.h"
#include <signal.h>
#include <pwd.h>

#define EQUIV(a,b)	( ((a) && (b)) || (!(a) && !(b)) )
#define eq(msg) (strcmp(msg, cargv[0]) == 0)
#define xerror printf	/* Need to somehow exit also */
#undef	NOTIMP	/* non-implemented stuff */
#ifndef	NOTIFY
#define	NOTIFY	/* always notify */
#endif	NOTIFY

int cargc;
char **cargv;
struct hbuf *header;

FILE *hfopen();
FILE *popen();
#ifdef __STDC__
FILE *mhopen(struct hbuf*);
FILE *mailhdr(struct hbuf*, char*);
#else
FILE *mhopen(), *mailhdr();
#endif
extern char *index();

char *senderof();

docontrol(h)
struct hbuf *h;
{
	register char *ctlmsgtext;

	header = h;
	if (strncmp(h->title, "cmsg ", 5) == 0) {
		register char *cp1, *cp2;
		cp1 = h->title;
		cp2 = h->title + 5;
		while(*cp1++ = *cp2++)
			;
	}

	if (*h->ctlmsg)
		ctlmsgtext = h->ctlmsg;
	else
		ctlmsgtext = h->title;
	log("Ctl Msg %s from %s: %s", h->nbuf, h->path, ctlmsgtext);
	/*
	 * Control messages have the standard format
	 *	command [args]
	 * much like shell commands.  Each site has the option
	 * of customizing this code to deal with control messages
	 * as they see fit, but we would like to buy back the
	 * code, ifdeffed or otherwise parameterized, to simplify
	 * the maintenence issues.
	 */
	argparse(ctlmsgtext);

	if (eq("cancel"))
		c_cancel(cargc, cargv);
	else if (eq("newgroup"))
		c_newgroup(cargc, cargv);
	else if (eq("ihave"))
		c_ihave(cargc, cargv);
	else if (eq("sendme"))
		c_sendme(cargc, cargv);
	else if (eq("sendbad"))
		c_sendme(cargc, cargv);
	else if (eq("rmgroup"))
		c_rmgroup(cargc, cargv);
	else if (eq("sendsys"))
		c_sendsys(cargc, cargv);
	else if (eq("senduuname"))
		c_senduuname(cargc, cargv);
	else if (eq("version"))
		c_version(cargc, cargv);
	else if (eq("checkgroups"))
		c_checkgroups(cargc, cargv);
	else if (eq("delsub"))
		c_unimp(cargc, cargv);
	else
		c_unknown(h, ctlmsgtext);
}

/*
 * Parse the string str into separate words in cargc and cargv
 * as per the usual UNIX convention.  Nothing fancy here, just
 * blanks and tabs separating words.
 */
#define CAVBUF_SIZE 256
argparse(str)
char *str;
{
	static char *cavpbuf[20];
	static char cavbuf[CAVBUF_SIZE];
	char *nextfree = cavbuf;
	int   i;

	if (str == '\0')
	    xerror ("Control message %s has no title", header->ident);
	cargc = 0;
	cargv = cavpbuf;
	cargv[0] = cavbuf;

	/* previous call leaves garbage in this buffer, and    */
	/* code below does not null-terminate the final "word" */

	for (i=0 ; i<CAVBUF_SIZE ; i++)
		  cavbuf[i] = '\0';

	while (*str) {
		if (*str <= ' ') {
			*nextfree++ = 0;
			cargc++;
			cargv[cargc] = nextfree;
			/* skip over white space */
			while (*str != '\0' && *str <= ' ')
				str++;
			if (*str == '\0')	/* line ends in white space */
				return;
		} else
			*nextfree++ = *str++;
	}
}

/*
 * ihave <artid> <remotesys>
 * The other system is telling you it has article <artid>, in case
 * you decide you want it to transmit it to you.
 */
c_ihave(argc, argv)
char **argv;
{
	char tl[256], ng[256];
#ifdef u370
	static struct hbuf htmp;
#else !u370
	struct hbuf htmp;
#endif !u370

#ifdef	NOTIMP
	if (argc < 2)
		xerror("ihave: Not enough arguments.");
	/*
	 * Check that we haven't already seen it (history)
	 * and then send back a "sendme" message if we subscribe.
	 */
	strncpy(htmp.ident, argv[1], BUFLEN);
	htmp.oident[0] = '\0';
	if (history(&htmp) == 0) {
		/* Should probably check SUBFILE here. */
		sprintf(tl, "sendme %s %s", argv[1], FULLSYSNAME);
		sprintf(ng, "to.%s.ctl", argv[2]);
		xmitmsg(argv[2], tl, ng);
	}
#endif	NOTIMP
}

/*
 * sendme <artid> ... <remotesys>
 * The other system wants me to send him article <artid>.
 */
c_sendme(argc, argv)
char **argv;
{
	int i;
	FILE *fp;
#ifdef	NOTIMP
	struct srec srec;
#endif	NOTIMP
#ifdef u370
	static struct hbuf h;
#else !u370
	struct hbuf h;
#endif !u370

	if (argc < 2)
		xerror("sendme: Not enough arguments.");
	/* Don't ask for it from myself */
	if (strncmp(full_hostname, argv[argc], strlen (full_hostname)) == 0)
		return;
#ifdef	NOTIMP
	/* Find the sys record */
	s_openr();
	while (s_read(&srec)) {
		if (strncmp(srec.s_name, argv[argc], SNLN))
			continue;
		/* It's the right one.  Send them. */
		for (i=1; i<argc; i++) {
			fp = hfopen(argv[i]);
			if (hread(&h, fp, TRUE) == NULL)
				xerror("Article %s is garbled.", argv[i]);
			fseek(fp, 0L, 0);
			if (strcmp(argv[0], "sendme") == 0) {
				/* check that other sys subscribes. */
				if (!ngmatch(h.nbuf, srec.s_nbuf) ||
					!(h.distribution[0] == '\0' ||
					ngmatch(h.distribution, srec.s_nbuf)))
					continue;
			}
			transmit(&srec, fp, 0);
			/* transmit does fclose(fp) */
		}
		return;
	}
	xerror("Cannot find system %s to send article %s to.", argv[argc],
		argv[1]);
#endif	NOTIMP
}

/*
 * newgroup <groupname>
 * A new newsgroup has been created.
 * The body of the article, if present, is a description of the
 * purpose of the newsgroup.
 *
 */
c_newgroup(argc, argv)
char **argv;
{
	FILE *fd;
	int rc;
	char title[TITLEN], body[1024], bfr[CMDLEN];
	struct io_f io;
	int old_group = FALSE;
	int old_mod_status, new_mod_status;

	if (argc < 1)
		xerror("newgroup: Not enough arguments.");

	if (init(&io, argv[1]) >= 0) {

	    /* Newsgroup already exists.  Moderation change, perhaps? */
	    old_group = TRUE;

	} else {

	    /* Really new newsgroup. */
	    sprintf (bfr, "exec %s/mknf -on %s", libdir, argv[1]);
	    rc = system (bfr);
	    log ("newsinput: system (%s) status %d", bfr, rc);

	    if (init(&io, argv[1]) < 0) {
		sprintf (title, "Newsgroup creation failed: %s", argv[1]);
		sprintf(body,
			"\nA new newsgroup called '%s' has been created by %s.\
\nThe return code was %d.\n",
		argv[1], header->path, rc);
		nfcomment (NOSUCHWARN, body, title, 0, 0);
		log ("newsinput: newsgroup creation failed: %s", argv[1]);
		return;
	    }
	}

	new_mod_status = (argc >= 2 && strcasecmp(argv[2], "moderated")==0);

	if (old_group) {
	    old_mod_status = is_moderated(&io);

	    if (EQUIV(old_mod_status,new_mod_status)) {
		sprintf(title, "Group %s is already %smoderated",
			argv[1], new_mod_status ? "" : "un");
		sprintf(body,
			"\n%s\n\
has requested that group %s be made %smoderated.  It already is.\n",
			header->path, argv[1], new_mod_status ? "" : "un");
	    } else {

		if (manual_mod_change) {
		    sprintf (title, "Please make %s %smoderated", argv[1],
			     new_mod_status ? "" : "un");
		sprintf(body,
			"\n%s\n\
has requested that %s be made %smoderated.\n\
You should do it by hand.\n",
			header->path, argv[1], new_mod_status ? "" : "un");
		} else {
		    if (new_mod_status) {
			make_moderated(&io, NULL);
		    } else {
			make_unmoderated(&io);
		    }
		    sprintf (title, "Group %s was made %smoderated",
			     argv[1], new_mod_status ? "" : "un");
		    sprintf(body,
			  "\nGroup '%s' has been made %smoderated by\n%s.",
			    argv[1], new_mod_status ? "" : "un", header->path);
		}
	    }
	} else {
	    /* New newsgroup */
	    if (new_mod_status) {
		make_moderated(&io, NULL);
	    }

	    /*
	     * Sample code to notify the contact person.
	     * Probably should dig up the text of the article
	     * and enclose that, too.  It can be found in the
	     * file ARTICLE.  Also, there needs to be
	     * an automatic provision to help you add the newsgroup.
	     *
	     */
	    sprintf (title, "New newsgroup: %s%s", argv[1],
		     new_mod_status ? " (moderated)" : "");
	    sprintf(body,
		    "\nA new%s newsgroup called '%s' has been created by\n\
%s.\nThe return code was %d.\n",
		    new_mod_status ? " moderated" : "",
		    argv[1], header->path, rc);
	}
	nfcomment (NOSUCHWARN, body, title, 0, 0);
	log ("newsinput: new newsgroup: %s", argv[1]);
}

/*
 * rmgroup <groupname>
 * An old newsgroup is being cancelled on a network wide basis.
 */

c_rmgroup(argc, argv)
char **argv;
{
	FILE *fd;
	int rc;
	char title[128], body[1024], bfr[256];

	if (argc < 1)
		xerror("rmgroup: Not enough arguments.");

	
	sprintf (title, "Remove newsgroup: %s", argv[1]);
	if (manual_rmgroup) {
	    sprintf(body,
	    "\n%s has requested that newsgroup %s be removed.\n\
You should remove it by hand\n",
			header->path, argv[1]);
	}
	else {
	    sprintf (bfr, "exec %s/rmnf -f %s", libdir, argv[1]);
	    rc = system (bfr);
	    sprintf(body,
	    "\nA newsgroup called '%s' has been removed by %s.\n\
The return code was %d\n",
		argv[1], header->path, rc);
	    log("system(%s) status %d", bfr, rc);
	}
	nfcomment (NOSUCHWARN, body, title, 0, 0);
}

/*
 * cancel <artid>
 * Cancel the named article
 */
c_cancel(argc, argv)
char **argv;
{
	char *line, *p, *q, *r, *poster;
	char *findhist();
	register FILE *fp;
	char whatsisname[150];
	char msgng[64];
	time_t t;
	int su = 0;

	if (argc < 1)
		xerror("cancel: Not enough arguments.");
#ifdef	NOTIMP
	strcpy(whatsisname, senderof(&header));
	strcpy(msgng, header->nbuf);
	line = findhist(argv[1]);
	if (line == NULL) {
		log("Can't cancel %s:  non-existent", argv[1]);
		(void) time(&t);
		sprintf(bfr,"%s\t%.12s\tcancelled", argv[1], &ctime(&t)[4]);
		savehist(bfr);
		return;
	}

	q = index(line, '\t');
	p = index(q+1, '\t');
	p++;
	if (strcmp(p, "cancelled") == 0) {
		*q = '\0';
		log("Already Cancelled %s", line);
		return;
	} else
		log("Cancelling %s", line);
	while (*p) {
		q = index(p, ' ');
		if (q)
			*q = '\0';
		strcpy(filename, dirname(p));
		fp = xfopen(filename, "r");
		if (hread(&header, fp, TRUE) == NULL)
			xerror("Article is garbled.");
		fclose(fp);
		if((uid==ROOTID||uid==0) && strncmp(msgng,"to.",3) == 0)
			su = 1;
		poster = senderof(&header);
		/* only compare up to '.' or ' ' */
		r = index(poster,'.');
		if (r == NULL)
			r = index(poster,' ');
		if (r != NULL)
			*r = '\0';
		if (!su && strncmp(whatsisname, poster,strlen(poster))) {
			xerror("Not contributor: posted by %s, and you are %s", poster, whatsisname);
		}

		cancel();
		p = q+1;
	}
#endif	NOTIMP
}

/*
 * sendsys	(no arguments)
 *
 * Mail the sys file to the person submitting the article.
 * POLICY: the contents of your sys file are public information
 * and as such, you should not change this code.  You may feel
 * free to arrange for it to manually notify you, in the event
 * that you want to do something to clean it up before it goes out.
 * Secret sites on the net are expressly frowned on.
 *
 * The purpose of this command is for making a network map.  The
 * details of your link and which newsgroups are forwarded are not
 * important, in case you want to sanitize them.  Since the definition
 * of USENET is those sites getting net.general, you can disable this
 * on sites not getting net articles, but if you take out the list of
 * forwarded newsgroups, and you have sites that only get local newsgroups,
 * you should make this clear, or remove those sites from what you send out.
 */
char SYSPROG[256] = "fakesys.sh"; /* need to grab from config file? */
#undef FAKESYS

c_sendsys(argc, argv)
char **argv;
{
	register FILE *f, *u, *fd;
	int c;
	char title[128], body[1024];
	char buf[256];

#ifdef lint
	argc += **argv;
#endif lint

	
	sprintf (title, "Sys file request");
	sprintf (body, "\n%s requested your sys file.\nIt has been sent.\n",
		 header->path);
	nfcomment (NOSUCHWARN, body, title, 0, 0);

#ifdef FAKESYS
	fd = mailhdr(header, "response to your sendsys request");
	if (SYSPROG[0] == '/')
		strcpy(buf, SYSPROG);
	else
		sprintf(buf, "%s/%s", libdir, SYSPROG);

	u = popen(buf, "r");
	if (fd != NULL && u != NULL) {
		while ((c=getc(u)) != EOF)
			putc(c, fd);
		pclose(u);
		mclose(fd);
	}
#else	
	f = mailhdr(header, "response to your sendsys request");
	
#ifdef	NOTIMP
	u = fopen(SUBFILE, "r");
	if (f != NULL && u != NULL) {
		while ((c=getc(u)) != EOF)
			putc(c, f);
		fclose(u);
		mclose(f);
	}
#else	NOTIMP
	fprintf (f, "Sorry, we're a notes site and there is currently\n");
	fprintf (f, "no equivalent to the news \"sys\" file.  We're\n");
	fprintf (f, "working on it.\n");
	mclose (f);
#endif	NOTIMP
#endif FAKESYS
}

/*
 * senduuname	(no arguments)
 *
 * Run the "uuname" command and send it back to the person who submitted
 * the article.  The purpose of this control message is for attempting to
 * make a uucp net map.
 *
 * POLICY: If you view this information as not public (because you have
 * a connection you consider secret, or know a site that considers itself
 * secret) you can feel free to change this code in whatever way is
 * appropriate, so long as it sends some response back to the sender.  If
 * you don't run uucp, this code does not make sense, and so an error
 * message (or garbage, such as "research") will be mailed back.
 *
 * If you wish to add or remove sites from the output of uuname, you
 * may wish to use the euuname.sh shell script here.
 */
char UUPROG[256] = "uuname";	/* needs to be picked up from config file*/

c_senduuname(argc, argv)
char **argv;
{
	char buf[256];
	FILE *fd, *u;
	int c;
	char title[64], body[1024];

#ifdef lint
	argc += **argv;
#endif lint

	sprintf (title, "Uuname control message");
	sprintf(body, "\n%s requested your uuname output\n", header->path);
	nfcomment (NOSUCHWARN, body, title, 0, 0);

	fd = mailhdr(header, "response to your senduuname request");
	if (UUPROG[0] == '/')
		strcpy(buf, UUPROG);
	else
		sprintf(buf, "%s/%s", libdir, UUPROG);

	u = popen(buf, "r");
	if (fd != NULL && u != NULL) {
		while ((c=getc(u)) != EOF)
			putc(c, fd);
		pclose(u);
		mclose(fd);
	}
}

/*
 * Send the version number to the right person.
 */
c_version(argc, argv)
char **argv;
{
	register FILE *f;

#ifdef lint
	argc += **argv;
#endif lint

	f = mailhdr(header, "Our news version");
	if (f == NULL)
		xerror("Cannot send back error message");
	fprintf(f, "\nCurrently running notes version %s.\n\n", NEWS_VERSION);
	fprintf(f, "The header of your message follows:\n");
	hwrite(header, f);
	mclose(f);
}

/*
 * Check the active file for old or missing newsgroups
 * Body of article is list of valid groups
 */
c_checkgroups(argc, argv)
char **argv;
{
	int rc;

#ifdef	NOTIMP
#ifdef lint
	argc += **argv;
#endif lint

	setuid(geteuid());
	sprintf(bfr, "sed '1,/^$/d' %s | %s/checkgroups %s",
		ARTICLE, LIB, (TELLME && *TELLME) ? TELLME : NEWSUSR);
	rc = system(bfr);
	log("system(%s) status %d", bfr, rc);
#endif	NOTIMP
}

/*
 * An unknown control message has been received.
 */
c_unknown(h, ctlmsgtext)
struct hbuf *h;
char *ctlmsgtext;
{
	register FILE *f;

	log("UNKNOWN Ctl Msg %s from %s", ctlmsgtext, h->path);
	f = mailhdr(h, "Unrecognized Control Message");
	if (f == NULL)
		xerror("Cannot send back error message");
	fprintf(f, "Currently running notes version %s.\n\n", NEWS_VERSION);
	fprintf(f, "The header of the message follows:\n");
	hwrite(h, f);
	mclose(f);
}

c_unimp(argc, argv)
char **argv;
{
	register FILE *f;

#ifdef lint
	argc += **argv;
#endif lint

	f = mailhdr(header, "Unimplemented Control Message");
	if (f == NULL)
		xerror("Cannot send back error message");
	fprintf(f, "Currently running notes version %s.\n\n", NEWS_VERSION);
	fprintf(f, "The header of the message follows:\n");
	hwrite(header, f);
	mclose(f);
}

xmitmsg(tosys, title, ng)
char *tosys, *title, *ng;
{
#ifdef u370
	static struct hbuf h;
#else !u370
	struct hbuf h;
#endif !u370
#ifdef	NOTIMP
	struct srec srec;
#endif	NOTIMP
	FILE *tfp;
	char *fname;

#ifdef	NOTIMP
	/* Make an article called ARTICLE */
	/* Something will need to be done about the following line... */
	sprintf(h.from, "%s@%s%s", "usenet", FULLSYSNAME, mydomain);
	strcpy(h.path, NEWSUSR);
	strcpy(h.nbuf, ng);
	strcpy(h.title, title);
	strcpy(h.ctlmsg, title);
	strcpy(h.subdate, "");
	strcpy(h.recdate, "");
	strcpy(h.expdate, "");
	getident(&h);
	dates(&h);
	tfp = xfopen(fname = mktemp("/tmp/xmsgXXXXXX"), "w");
	hwrite(&h, tfp);
	fclose(tfp);

	/* Find the sys record */
	s_openr();
	while (s_read(&srec)) {
		if (strncmp(srec.s_name, tosys, SNLN))
			continue;
		tfp = xfopen(fname, "r");
		transmit(&srec, tfp, 0);
		unlink(fname);
		return;
	}
	log("Can't find sys record for %s", tosys);
	xerror("Cannot find sys record");
#endif	NOTIMP
}

/*
 * This is a modified version of popen, made more secure.  Rather than
 * forking off a shell, you get a bare process.  You must have exactly
 * one argument, and the command must be mail.
 */
#define	RDR	0
#define	WTR	1
static	int	mopen_pid[20];
#ifdef __STDC__
char *replyname(struct hbuf*);
#else
char *replyname();
#endif

FILE *
mhopen(hptr)
struct hbuf *hptr;
{
	int p[2];
	register myside, hisside, pid;
	char *sendto = NULL;


	if (hptr)
		sendto = replyname(hptr);
	else {
		sendto = NOTESUID;
	}
	verifyname(sendto);
	if(pipe(p) < 0)
		return NULL;
	myside = p[WTR];
	hisside = p[RDR];
	if((pid = fork()) == 0) {
		/* myside and hisside reverse roles in child */
		closeRFA();	/* see lib/dosystem.c */
		close(myside);
		close(0);
		dup(hisside);
		close(hisside);
		execl("/usr/lib/sendmail", "rmail", sendto, (char *)NULL);
		execl("/usr/bin/mailx", "mail", sendto, (char *)NULL);
		execl("/bin/mail", "mail", sendto, (char *)NULL);
		execl("/usr/bin/mail", "mail", sendto, (char *)NULL);
		execl("/usr/ucb/mail", "mail", sendto, (char *)NULL);
		_exit(1);
	}
	if(pid == -1)
		return NULL;
	mopen_pid[myside] = pid;
	close(hisside);
	return(fdopen(myside, "w"));

}

mclose(ptr)
FILE *ptr;
{
	register int f, r;
	register SIGHNDLR (*hstat)(), (*istat)(), (*qstat)();
	int status;

	f = fileno(ptr);
	fclose(ptr);
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	hstat = signal(SIGHUP, SIG_IGN);
	while((r = wait(&status)) != mopen_pid[f] && r != -1)
		;
	if(r == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	signal(SIGHUP, hstat);
	return(status);
}

/*
 * mhopen a pipe to mail, write out a std header, and return the file ptr.
 *
 * We don't include a From: field because this is probably uucp, i.e.
 * explicitly routed.  Leave it up to the recipient's mailer.
 * Always include the To: field because if we ge back failed mail, we
 * might be able to deliver it by hand if we know to wom it was addressed.
 * By convention, hptr==NULL means to send the message to the local contact person.
 */
FILE *
mailhdr(hptr, subject)
struct hbuf *hptr;
char  *subject;
{
	FILE *fp;
	time_t now;
	char *to = "nobody";

	if (hptr)
		to = replyname(hptr);
	else
		to = NOTESUID;

	if ((fp = mhopen(hptr)) != NULL) {
		time(&now);
		fprintf(fp, "Date: %s\n", arpadate(&now));
		fprintf(fp, "To: %s\n", to);
		fprintf(fp, "Subject: %s\n", subject);
		fprintf(fp, "Responding-System: %s%s\n", this_system, mydomain);
	}
	return fp;
}

/*
 * verify that the name mail is being sent to does not contain any
 * nasty hooks to invoke funny functions from the shell or the like.
 */
verifyname(sendto)
char *sendto;
{
	/* Be sure we DO allow alphabetics, !, :, ., -, @. *. */
	char *nasty = "\"'\\`^|;& <>/~";
	register char *p;

	if (sendto[0] <= ' ') {
		log("nasty mail name %s from %s", sendto, header->path);
		exit(1);
	}
	for (p=sendto; *p; p++) {
		if (*p == ' ') {
			*p = 0;
			break;
		}
	}
	while (*nasty) {
		if (index(sendto, *nasty++))
			xerror("nasty mail name %s from %s", sendto, header->path);
	}
	for (nasty = sendto; (nasty = index(nasty, '.')) != NULL; ) {
		if (*++nasty == '.')	/* check for .. */
			xerror("nasty mail name %s from %s", sendto, header->path);
	}
}

/*
 * Checks to make sure the control message is OK to post.
 */
ctlcheck(header)
struct hbuf *header;
{
	char msg[150];
	char *p;

	if (header->ctlmsg[0])
		strcpy(msg, header->ctlmsg);
	else
		strcpy(msg, header->title);

	p = index(msg, ' ');
	if (p)
		*p = 0;

	if (strcmp(msg, "ihave") == 0) {
	} else if (strcmp(msg, "sendme") == 0) {
		return;	/* no restrictions */
	} else if (strcmp(msg, "newgroup") == 0) {
		suser();
	} else if (strcmp(msg, "rmgroup") == 0) {
		suser();
		checkpass("mTnyckAVEMXWk");
	} else if (strcmp(msg, "sendsys") == 0) {
		suser();
	} else if (strcmp(msg, "senduuname") == 0) {
		suser();
	} else if (strcmp(msg, "checkgroups") == 0) {
		suser();
	} else if (strcmp(msg, "version") == 0) {
		return;	/* no restrictions */
	} else if (strcmp(msg, "cancel") == 0) {
		return;	/* no restrictions at this level */
	} else if (strcmp(msg, "delsub") == 0) {
		if (!prefix(header->nbuf, "to.")) {
			printf("Must be in a 'to.system' newsgroup.");
			exit(0);
		}
		return;
	} else {
		printf("Unrecognized control message - %s\n", msg);
		exit(0);
	}
}

/* Make sure this guy is special. */
suser()
{
	int uid;
	extern struct passwd *getpwnam();
	
	uid = getuid();
	if (uid == 0)
		return;
	if (uid == getpwnam(NOTESUID)->pw_uid)
		return;
	/*
	 * We assume that since our real uid is the same as NEWSUSR
	 * (the euid) we were run by rootid and it did a setuid.
	 * Too bad we can't set just the effective uid like suid does.
	 */
	if (uid == geteuid())
		return;
	printf("Get your local netnews contact to do it for you.\n");
	exit(0);
}

/*
 * Demand a password from the user.
 */
checkpass(encpw)
char *encpw;
{
	char *crypt(), *getpass();

	if (strcmp(encpw, crypt(getpass("Password:"), "mT"))) {
		printf("Sorry\n");
		exit(0);
	}
}

char *replyname (header)
struct hbuf *header;
{
/* STUB!!!!! */
  char *ptr;
  
  ptr = header->path;
  if (header->from[0])
    ptr = header->from;
  if (header->replyto[0])
    ptr = header->replyto;

  return ptr;
}


hwrite(h, f)
struct hbuf *h;
FILE *f;
{
#define puthdr(string, value) if (value[0]) fprintf (f, string, value)

    puthdr ("From: %s\n", h->from);
    puthdr ("Path: %s\n", h->from);
    puthdr ("Newsgroups: %s\n", h->nbuf);
    puthdr ("Distribution: %s\n", h->distribution);
    puthdr ("Subject: %s\n", h->title);
    puthdr ("Organization: %s\n", h->organization);
    puthdr ("Message-Id: %s\n", h->ident);
    puthdr ("Date: %s\n", h->subdate);
    puthdr ("Date-Received: %s\n", h->recdate);
    puthdr ("Control: %s\n", h->ctlmsg);
}
