/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/display.c,v 2.0 89/04/15 23:44:38 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include <time.h>

struct dsply_f {
	long	tlen;			/* output index and end of buffer */
	long	outcount;		/* number of characters dumped */
};

#define ROTATE 13
char *strchr();
char *strrchr();

static char *Continued = "-- more  %ld%% --";
static char bottom[81];		/* preconstructed bottom line */

#ifdef __STDC__
struct auth_f *parseauth(char*);
#else
struct auth_f *parseauth();
#endif
/*
 * dspmsg(io,note,resp,phys,logical)
 *
 * Code to print the header and manage the paging of a response
 * It calls the "showit" routine to print pages of text
 * displays a completely formatted message on the screen.
 */
dspmsg(io, note, msgp, logical, notenum)
struct io_f *io;
struct note_f *note;
struct msg_f *msgp;
{
	int i, j, r, c, lc, lo;
	struct txthead_f txthead;
	struct dsply_f dispbuf;
	long where, pagecnt[PAGESAV];		/* stack for backing up */
	int pagesout;
	char majorid[40], minorid[40];
	char datestr[40];
	char buf[BUFLEN];
	char auth[BUFLEN];
	char auth_addr[BUFLEN];
	char organization[128];
	struct auth_f *auth_f;
	int sline;
	int Rotate = 0;

	gethdr(io, msgp, msgp->m_from, auth);
	gethdr(io, msgp, msgp->m_org, organization); 
	sprintf(majorid, "Note %3d of %3d", notenum, io->descr.d_nnote);
	if (logical) {
		sprintf(minorid, "Resp %3d of %3d", logical, note->n_nresp);
		io->nrspread++;		/* bump count of responses read */
	} else {
		if (note->n_nresp == 0)
			strcpy(minorid, "No responses");
		else {
			sprintf(minorid, "%d Response%s", note->n_nresp,
			    note->n_nresp > 1 ? "s" : "");
		}
		io->nnotread++;		/* bump count of notes read */
	}
	sprdate(msgp->m_subtime, datestr);

	pagesout = 0;
	pagecnt[pagesout] = 0;

	if (msgp->m_addr.addr == 0)
		dispbuf.tlen = 0;	/* so can get a header */
	else {
		gethrec(io, &msgp->m_addr, &txthead);
		dispbuf.tlen = txthead.textlen;
	}
	dispbuf.outcount = 0; /* fix buffer */

	do {					/* always make 1 pass */
		if (dispbuf.outcount == 0) {
			/* format the notes display header */
			erase();

			at(1, 1);
			fputs(datestr, stdout);

			i = (ncols - strlen(io->descr.d_title)) / 2;
			at(1, i);
			fputs(io->descr.d_title, stdout);

			at(1, -16);
			fputs(majorid, stdout);

			strncpy(buf, note->n_title, ncols-17); /* max len */
			buf[ncols-17] = 0;
			j = strlen(buf);
			i = (ncols - j - 1) / 2;
			if (i+j > ncols-17) { /* title doesn't fit centered */
				i = (ncols-16) - j;
			}
			at(2, i);
			fputs(buf, stdout);

			at(2, -16);
			fputs(minorid, stdout);

			at(3, 1);
			auth_f = parseauth(auth);
			/* note the added space so fullname doesn't touch */
			sprintf(auth_addr, "%s@%s ",auth_f->a_name,
				auth_f->a_sys);
			fputs(auth_addr, stdout);

			/* will "human name" and it fit?
			   if not, truncate both parts "evenly" */

			lc = strlen(auth_f->a_comment);
			lo = strlen(organization);
			r = ncols - (strlen(auth_addr)+5);
			if (r < 0) r = 0;
			if (r > sizeof(auth_addr)-5) r = sizeof(auth_addr) - 5;
			if (lc + lo > r) {
				j = r/2;
				if (lo < j)
					auth_f->a_comment[r-lo] = '\0';
				else if (lc < j)
					organization[r-lc] = '\0';
				else {
					organization[j] = '\0';
					auth_f->a_comment[j] = '\0';
				}
			}

			strcpy(buf, auth_f->a_comment);
			if (organization[0]) {
			    strcat(buf," at ");
			    strcat(buf,organization);
			}
			if (buf[0]) {
			    at (3, -strlen(buf));
			    fputs(buf, stdout);
			}

			strcpy(bottom, "          "); /* space for prompt */
			if (notenum == 0) strcat(bottom, "POLICY NOTE ");

			if (msgp->m_stat & DIRMES) {
				strcat(bottom, io->descr.d_drmes);
			}
			if (note -> n_stat & WRITONLY) {
				strcat (bottom, " (Write Only)");
			}

			at(4, 1);
			sline = 3;
		}
		else if (can_lock()) {
			/* we can scroll, so do so */
		        at (5, 1);		/* end of header (incl blank) */
		        m_lock ();		/* lock header on screen */
		        at (0, 1);		/* clear more/prompt line */
		        ceol ();
		        at (-1, 1);		/* for newline below */
			sline = 4;
		}
		else {
			/* format the continued notes display header */
			erase();
			at(1, 1);
			printf("%s [continued]:  %s", majorid, note->n_title);
			sline = 2;
			at(2, 1);
		}

		/* display the message */
		if (dispbuf.tlen == 0) {
			c = -1;
			at (5, 36);
			fputs ("[No Text]", stdout);
			break;			/* header is all for empties */
		}
		putc('\n', stdout);		/* make sure soft-tabs work */
		showit(io, &dispbuf, sline, Rotate);


		/* process pager command */
		cmdprompt();
		c = gchar(0);

		/* left locked for local scrolling; now that we have a
		   command, unlock it (if it was). */
		if (can_lock()) 
			m_ulock();

		switch (c) {
		case ' ':			/* wants the next page */
		case 'l':			/* universal seq, RLS */
			if (pagesout < PAGESAV-1) {
				pagesout++;
				pagecnt[pagesout] = dispbuf.outcount;
			}
			/* save new start */
			break;

#ifdef	ROTATE
		case '%':	 /* rot-13 the text */
			Rotate = !Rotate;/* toggle */
			pagesout = 1;
			/* and fall into re-plot */
#endif  ROTATE
#define	CTRL(x)	('x' & 037)
		case CTRL(R):
		case '\f':
		case '-': 			/* go back to previous */
		case '\b':
			if (c == CTRL(R))
				pagesout = 0;
			else if (c != '\f') {
				if (--pagesout < 0)
					return(c);
			}
			dispbuf.outcount = pagecnt[pagesout];
			where = msgp->m_addr.addr + (sizeof txthead) +
			    dispbuf.outcount;
			x(fseek(io->fidtxt, where, 0) < 0, "dspmsg: bad seek");
			break;				/* are all set now */

		default:
			return(c);
		}
	} while (dispbuf.outcount < dispbuf.tlen);

	if (msgp->m_stat & CONTINUED) {
		at(0, -40);
		printf("-- Continued in next response --");
	}
	return(c);				/* didn't field a command */
}

/*
 *	showit
 *
 *	accepts a pointer to a dsply_f and dumps text until runs out
 *	or the screen is filled.
 *	Counts things like lines, columns, and also prints a "more" line
 */
showit(io, dbuf, sline, Rotate)
struct io_f *io;
struct dsply_f *dbuf;
{
	register int c;
	register int lines, wides;
	int botrow = nrows - 2;

	lines = sline;
	wides = 0;
	while (lines < botrow && dbuf->outcount < dbuf->tlen) {
		/* show the character */
		c = getc(io->fidtxt);
		dbuf->outcount++;
#ifdef	ROTATE
		if (Rotate)
		{
		    if ((c >= 'a' && c <= 'm') || (c >= 'A' && c <= 'M'))
			c += ROTATE;
		    else
			if ((c >= 'n' && c <= 'z') || (c >= 'N' && c <= 'Z'))
			    c -= ROTATE;
		}
#endif	ROTATE
		/* filter out dangerous stuff */
		if ((c < 0x07) || ((c >= 0x10) && (c < 0x20)))
			continue ;		/* go get another char */
		else {
			putchar(c);
		}
		switch (c) {
		/* some special chars */
		case '\n': 				/* next line */
			wides = 0;
			lines++;
			/* check for typeahead every once in a while */
			if (isinput())
				return;
			break;

		case '\014': 				/* force next page */
			lines = nrows;			/* forces loop exit */
			break;

		case '\t': 				/* almost forgot tabs */
			wides += (8 - (wides % 8));	/* tab stops */
			break;

		case '\b':			/* perverts using backspaces */
			wides--;
			break;

		default: 			/* dull characters */
			wides++;
			break;
		}
		if (wides >= ncols) {		/* test line overflow */
			lines++;
			wides = 0;
		}
	}

	at (0,1);
	fputs(bottom,stdout);

	if (dbuf->outcount < dbuf->tlen) {
		at(0, 60);
		printf(Continued, dbuf->outcount * 100 / dbuf->tlen);
	}
}

/*
 *	print the index page for a notefile
 */
prntind(io, firstdis, lastdis)
	struct io_f *io;
	int *firstdis, *lastdis;
{
	struct note_f note;
	time_t date;
	struct tm *tm;
	struct tm *localtime();
	int atrow;			/* printing row counter */
	int lyr, lday, lmon;	       /* so we know if need to reprint date */
	int i;
	extern int terse;
	int nprint;
	int lastprint;
	char auth[BUFLEN];

	erase();

	at(1, 1);
	time(&date);				/* screen will look nice */
	prdate(date);

	i = (ncols - strlen(io->descr.d_title)) / 2;
	at(2, i);
	fputs(io->descr.d_title, stdout);

	/* if the title isn't the newsgroup name, print the name as well */
	if (strcmp(io->descr.d_title, io->nf) != 0) {
		i = ((ncols - strlen(io->nf)) / 2)-1;
		at(3, i);
		fputs("(", stdout);
		fputs(io->nf, stdout);
		fputs(")", stdout);
	}

	atrow = 5;				/* start printing here */
	lyr = lday = lmon = 0;			/* unknown prev date */
	if (*firstdis > io->descr.d_nnote - nindex + 1) {
		*firstdis = io->descr.d_nnote - nindex + 1;
	}
	if (*firstdis < 1) {
		*firstdis = 1;
	}
	*lastdis = *firstdis + nindex - 1;

	lastprint = -1;
	nprint = 0;
	for (i = *firstdis; nprint < nindex && i <= io->descr.d_nnote; i++) {
		/* which does not execute for empty file */
		getnrec(io, i, &note);
		if (note.n_stat & DELETED)
			continue;
		if (terse && note.n_lmod < io->stime)
			continue;
		/* need to print date? */
		tm = localtime(&note.n_msg.m_rcvtime);
		if (tm->tm_year != lyr  ||
		    tm->tm_mon  != lmon ||
		    tm->tm_mday != lday   ) {
			at(atrow, 1);
			lmon = tm->tm_mon;
			lday = tm->tm_mday;
			printf("%d/%d", lmon+1, lday);
			if (tm->tm_year != lyr) {
				lyr = tm->tm_year;
				printf("/%02d", lyr);
			}
		}

		at(atrow, 10);
		printf("%3d", i);
		if (io->stime && note.n_lmod >= io->stime)
			putchar('+');
		else
			putchar(' ');
		printf("%.36s", note.n_title);
		if (note.n_nresp != 0) {
			at(atrow, 52);
			printf("%3d", note.n_nresp);
		}
		at(atrow, 55);
		if (note.n_stat & DIRMES)
			putchar('*');
		else
			putchar(' ');
		gethdr(io, &note.n_msg, note.n_msg.m_from, auth);
		printf("%.24s", auth);
		if (isinput())
			return;
		fflush(stdout);	/* otherwise, we see BUFSIZ chunks */
		atrow++;
		lastprint = i;
		nprint++;
	}
	if (lastprint > *lastdis)
		*lastdis = lastprint;
	if (*lastdis >= io->descr.d_nnote) {
		at (++atrow, 14);
		printf ("**** End of Notes ****");
	}
}
