/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/*
 * We implement getpwnam(), getpwuid(), and getgrnam() using the primitive
 * iteration functions (*ent()), in order to avoid constant allocations and
 * frees of fgets() buffers when the normal *nam() routines clean up after
 * finding what they're looking for.  This will lose if we're using a database
 * with slow iteration, but that can be handled elsewhere.
 *
 * The get2* functions do a double-take on failures, to compensate for any
 * possible file caching.
 */

#include "hostenv.h"
#include <stdio.h>
#include <pwd.h>
#include <grp.h>

struct passwd *
get2pwnam(name)
	char *name;
{
	struct passwd *pw;
	extern struct passwd *getpwnam();

	if ((pw = getpwnam(name)) == NULL) {
		endpwent();
		if ((pw = getpwnam(name)) == NULL)
			return NULL;
	}
	return pw;
}

struct passwd *
get2pwuid(uid)
	int uid;
{
	struct passwd *pw;
	extern struct passwd *getpwuid();

	if ((pw = getpwuid(uid)) == NULL) {
		endpwent();
		if ((pw = getpwuid(uid)) == NULL)
			return NULL;
	}
	return pw;
}

#ifndef	USE_GETPWNAM

struct passwd *
zgetpwnam(name)
	char *name;
{
	struct passwd *pw;
	extern struct passwd *getpwent();

	setpwent();
	while ((pw = getpwent()) != NULL)
		if (strcmp(name, pw->pw_name) == 0)
			return pw;
	return NULL;
}

struct passwd *
zgetpwuid(uid)
	int uid;
{
	struct passwd *pw;
	extern struct passwd *getpwent();

	setpwent();
	while ((pw = getpwent()) != NULL)
		if (uid == pw->pw_uid)
			return pw;
	return NULL;
}

struct group *
zgetgrnam(name)
	char *name;
{
	struct group *gr;
	extern struct group *getgrent();

	setgrent();
	while ((gr = getgrent()) != NULL)
		if (strcmp(name, gr->gr_name) == 0)
			return gr;
	return NULL;
}
#endif	/* !USE_GETPWNAM */
