/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/*
 * Perhaps a single interface to discovering the real system name.
 */

#include <stdio.h>
#include "hostenv.h"
#if	defined(USE_HOSTS) || defined(USE_RESOLV)
#include <netdb.h>
#endif	/* USE_HOSTS */
#ifdef	USE_UNAME
#include <sys/utsname.h>
#endif	/* USE_UNAME */

#ifdef USE_RES_GETHOSTBYXXX
struct hostent *res_gethostbyname();
#define gethostbyname res_gethostbyname
#endif

int
getmyhostname(namebuf, len)
	char *namebuf;
	int len;
{
#if	defined(USE_HOSTS) || defined(USE_RESOLV)
	struct hostent *hp;
#endif	/* USE_HOSTS */
#ifdef	USE_UNAME
	struct utsname id;
	extern int uname();

	if (uname(&id) < 0)
		return -1;
	if (strlen(id.nodename) < len)
		(void) strcpy(namebuf, id.nodename);
#else	/* !USE_UNAME */
	extern int gethostname();
	
	if (gethostname(namebuf, len) < 0)
		return -1;
#endif	/* USE_UNAME */
#if	defined(USE_HOSTS) || defined(USE_RESOLV)
	if ((hp = gethostbyname(namebuf)) != NULL) {
		if (strlen(hp->h_name) < len)
			(void) strcpy(namebuf, hp->h_name);
	}
#if 0
	/* enable this code if for some reason your PTR name is primary */
	if (hp != NULL && (hp = gethostbyaddr(hp->h_addr,
				hp->h_length, hp->h_addrtype)) != NULL) {
		(void) strcpy(namebuf,hp->h_name);
	} else
		return -1;
#endif
#endif	/* USE_HOSTS */
	return 0;
}

