Summary: Mailer for extreme performance demands, secure mail delivery agent
Name: zmailer
Version: 2.99.51
Release: 1
Group: Networking/Daemons
Packager: Xose Vazquez <xose@ctv.es>

URL: http://www.zmailer.org 
Source: ftp://ftp.funet.fi/pub/unix/mail/zmailer/src/zmailer-%{version}.tar.gz
Source1: zmailer.init
Source2: zmailer.logrotate
Source3: zmailer.cron
Patch1: zmailer-procmail.patch

License: Freely usable, see /usr/doc/zmailer-%{version}/README
BuildRoot: /var/tmp/zmailer-%{version}-root
Prereq: /sbin/chkconfig
Requires: procmail
Provides: smtpdaemon
Conflicts: sendmail qmail

%description
This is a package that implements an internet message transfer agent
called ZMailer.  It is intended for gateways or mail servers or other
large site environments that have extreme demands on the abilities of
the mailer.  It was motivated by the problems of the Sendmail design
in such situations. ZMailer is one of the mailers able to deal with
huge quantities of mail and is more efficient any other mailer, qmail
included, mostly due to its excellent queueing algorithms.

Most users don't need this package -- for most users, sendmail or exim or
smail will suffice.

%prep
# unpack zmalier (and patch it).
%setup -q 
%patch1 -p1

# build zmailer
%build
CFLAGS="$RPM_OPT_FLAGS" \
	./configure --prefix=/usr \
	--libdir=/usr/lib \
	--includedir=/usr/include/zmailer \
	--with-zconfig=/etc/zmailer/zmailer.conf \
	--with-mailbox=/var/spool/mail \
        --with-postoffice=/var/spool/postoffice \
        --with-mailshare=/etc/zmailer \
        --with-mailvar=/etc/zmailer \
	--with-mailbin=/usr/lib/zmailer \
	--with-logdir=/var/log/mail \
        --with-sendmailpath=/usr/sbin/sendmail \
        --with-rmailpath=/usr/sbin/rmail \
        --with-system-malloc \
	--with-tcp-wrappers=/usr \
	--with-ta-mmap 
make -j 5

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=$RPM_BUILD_ROOT

# install man pages
# make install can't create man[1,3,5,8]. Well, make it ourself.
cd $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/man/man{1,3,5,8}

# Makefile error??
cd $RPM_BUILD_DIR/zmailer-%{version}/man
make

cd $RPM_BUILD_DIR/zmailer-%{version}/
make prefix=$RPM_BUILD_ROOT -C man install

# make install do not install authuser.3 
install -m644 $RPM_BUILD_DIR/zmailer-%{version}/man/authuser.3 \
        $RPM_BUILD_ROOT/usr/man/man3

# strip only binary files
strip `file $RPM_BUILD_ROOT/usr/lib/zmailer/* | awk -F':' '/not strip/ { print $1 }'`
strip `file $RPM_BUILD_ROOT/usr/lib/zmailer/ta/* | awk -F':' '/not strip/ { print $1 }'`

# install SYSV init stuff
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m755 $RPM_SOURCE_DIR/zmailer.init \
        $RPM_BUILD_ROOT/etc/rc.d/init.d/zmailer

for I in 0 1 6; do
	mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc$I.d
        ln -sf ../init.d/zmailer \
		$RPM_BUILD_ROOT/etc/rc.d/rc$I.d/K30zmailer
done
for I in 2 3 4 5; do
	mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc$I.d
        ln -sf ../init.d/zmailer \
		$RPM_BUILD_ROOT/etc/rc.d/rc$I.d/S80zmailer 
done

# install log rotation stuff
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
install -m644 $RPM_SOURCE_DIR/zmailer.logrotate \
	$RPM_BUILD_ROOT/etc/logrotate.d/zmailer

# install cron stuff
mkdir -p $RPM_BUILD_ROOT/etc/cron.daily/
install -m644 $RPM_SOURCE_DIR/zmailer.cron \
	 $RPM_BUILD_ROOT/etc/cron.daily/zmailer

# config files

for I in aliases fqdnaliases localnames routes smtp-policy.relay \
	smtp-policy.src ; do 
ln -sf proto/$I \
	$RPM_BUILD_ROOT/etc/zmailer/db/$I
done

for I in scheduler.conf sm.conf smtpserver.conf ; do
ln -sf proto/$I \
	$RPM_BUILD_ROOT/etc/zmailer/$I
done 

ln -sf cf/SMTP+UUCP.cf \
	$RPM_BUILD_ROOT/etc/zmailer/router.cf

ln -sf zmailer/db/proto/aliases $RPM_BUILD_ROOT/etc/aliases

# sendmail compatible stuff

ln -sf zmailer/sendmail $RPM_BUILD_ROOT/usr/lib/sendmail

for I in rmail sendmail; do
ln -sf ../lib/zmailer/$I $RPM_BUILD_ROOT/usr/sbin/$I
done

mkdir -p $RPM_BUILD_ROOT/usr/bin/
for I in mailq newaliases vacation; do
ln -sf ../lib/zmailer/$I \
	$RPM_BUILD_ROOT/usr/bin/$I
done

%preun
# stop zmailer if it is running
if ps auxw | egrep 'router|scheduler|smtpserver' | grep -v egrep \
	>> /dev/null ; then
        /usr/lib/zmailer/zmailer kill
	echo "1" > /var/run/.zmailer_was_run
fi

%post
/sbin/chkconfig --add zmailer

echo "localhost" >> /etc/zmailer/db/localnames

# mail.conf stuff
if [ -s /etc/mail.conf ] >> /dev/null ; then
	:
else
	touch /etc/mail.conf
fi
if grep -c -v '^#' /etc/mail.conf >> /dev/null ; then
        :
else
        [ -z "`hostname -d`" ] || echo "orgdomain=`hostname -d`" >> /etc/mail.conf
        [ -z "`hostname -d`" ] || echo "mydomain=`hostname -d`" >> /etc/mail.conf
        [ -z "`hostname -f`" ] || echo "hostname=`hostname -f`" >> /etc/mail.conf
fi

# make zmailer group
if grep -c "^zmailer:" /etc/group >> /dev/null ; then
        :
else
        # Use 'mail' group for zmailer...
        echo "zmailer::12:root,daemon,uucp" >> /etc/group
fi

# port to mailer transport queue
if grep -c "^mailq" /etc/services >> /dev/null ; then
        :
else
        echo "mailq           174/tcp                         # Mailer transport queue" >> /etc/services
fi

# rebuild the zmailer aliases database
/usr/lib/zmailer/newaliases

# recreates the FQDN alias map
/usr/lib/zmailer/newfqdnaliases

echo "`hostname -f`" >> /etc/zmailer/db/proto/localnames
echo "`hostname`" >> /etc/zmailer/db/proto/localnames
echo "`hostname -d`" >> /etc/zmailer/db/proto/localnames
echo "localhost.`hostname -d`" >> /etc/zmailer/db/proto/localnames

# start it back up again, after an upgrade
if [ -s /var/run/.zmailer_was_run ] >> /dev/null ; then
	/etc/rc.d/init.d/zmailer start
	rm -f /var/run/.zmailer_was_run
fi

%clean
rm -rf $RPM_BUILD_ROOT

%changelog

* Thu Jul 29 1999 Xose Vazquez <xose@ctv.es>

-  based on zmailer-%{version}/contrib/zmailer49.spec
-  this is the first version, is all ok ?


%files
%defattr(-,root,root)
/etc/aliases
%config /etc/cron.daily/zmailer
%config /etc/logrotate.d/zmailer
%config /etc/rc.d/init.d/zmailer
%config(missingok) /etc/rc.d/rc0.d/K30zmailer
%config(missingok) /etc/rc.d/rc1.d/K30zmailer
%config(missingok) /etc/rc.d/rc2.d/S80zmailer
%config(missingok) /etc/rc.d/rc3.d/S80zmailer
%config(missingok) /etc/rc.d/rc4.d/S80zmailer
%config(missingok) /etc/rc.d/rc5.d/S80zmailer
%config(missingok) /etc/rc.d/rc6.d/K30zmailer
%config(noreplace) /etc/zmailer/cf/*
%config(noreplace) /etc/zmailer/db/*
/etc/zmailer/forms
/etc/zmailer/fqlists
/etc/zmailer/lists
%config(noreplace) /etc/zmailer/proto/*
%config(noreplace) /etc/zmailer/router.cf
%config(noreplace) /etc/zmailer/scheduler.conf
%config(noreplace) /etc/zmailer/sm.conf
%config(noreplace) /etc/zmailer/smtpserver.conf
%config /etc/zmailer/vacation.msg
%config /etc/zmailer/zmailer.conf
/usr/bin/*
/usr/include/zmailer/zmailer.h
/usr/lib/libzmailer.a
/usr/lib/sendmail
/usr/lib/zmailer
# man pages
/usr/man/*/*
/usr/sbin/*
%dir /var/log/mail
%attr(2755,root,root) %dir /var/spool/postoffice/
%attr(750,root,root) /var/spool/postoffice/deferred/
%attr(750,root,root) /var/spool/postoffice/freezer/
%attr(750,root,root) /var/spool/postoffice/postman/
%attr(1777,root,root) /var/spool/postoffice/public/
%attr(750,root,root) %dir /var/spool/postoffice/queue/
%attr(755,root,root)  /var/spool/postoffice/queue/*
%attr(1777,root,root) /var/spool/postoffice/router/
%attr(755,root,root) /var/spool/postoffice/transport/
%doc  ChangeLog INSTALL MANIFEST Overview README* TODO doc contrib/README.debian

# EOF 
