#! /bin/sh
#
#  LaTeX2HTML wrapper
#
# Arguments:
#
# 1)  ZMANUAL-HEAD.TEX ZMANUAL-TAIL.TEX ZMANUAL.TEX
# 2)  FILENAME INTERNALPREFIX LEVEL "topicsubject"
#

PREFIXES="TUT INS ADM REF RSM RSE RRM RZL RRT RSC RTA RUT ASC ALM ATA AFM ASS"
INTERNALS="contents figure index internals labels sections table"

L2HTOPTITLE="ZMailer"
L2HTOP=zmanual
L2HCONTENTS=node20
L2HINDEXNODE=node21
L2HCHGNODE=node22
L2HREFNODE=node23
L2HGLOSSNODE=node24

TEXENV="`cat TEXENV`"

if [ "$#" -eq 3 ]; then
    # $1 = zmanual-head.tex
    # $2 = zmanual-tail.tex
    # $3 = zmanual.tex

(
    cat <<EOF
% --------------------------------
%  This is generated by combining files
%    $1
%    $2
%  and a script output
%
EOF
    cat $1

    for Y in $INTERNALS
    do

	for X in $PREFIXES
	do
	    echo "\\internal[$Y]{$X}"
	done
    done

    cat $2
) > $3
    exit 0
fi

FNAME=$1
IPFX=$2
LEVEL=$3
SUBJ="$4"
PTRNAME=`basename $FNAME .tex`.ptr

L2H="latex2html  -no_math -html_version 3.2,math"
L2HCOMMON="	-external_file zmanual -no_subdir -toc_depth 8 \
		-contents $L2HCONTENTS.html -index $L2HINDEXNODE.html \
		-biblio $L2HREFNODE -no_auto_link -no_footnode	\
		-split 2 -link 8 -up_url $L2HTOP.html			\
		-up_title $L2HTOPTITLE -show_section_numbers		\
		-short_index -info 0"

#
#

for X in $PREFIXES
#for X in $IPFX
do
    for Y in $INTERNALS
    do
	if [ ! -f $X$Y.pl ] ; then
	    echo "1;" > $X$Y.pl
	fi
    done
done

#
#

(
    cat <<EOF
%% 
%% Source produced from $FNAME with
%% L2H.sh script for LaTeX2HTML (98.1p1) processing
%% 
\\begin{htmlonly}
\\documentclass{article}
\\usepackage{html,color,makeidx,graphicx}
\\input{manhtml}
\\input{${PTRNAME}}
\\end{htmlonly}

EOF

#    echo "\\internal[images]{}"
#
#    for Y in $INTERNALS
#    do
#	echo "\\internal[$Y]{$X}"
#    done


    for X in $PREFIXES
    do

#	for Y in $INTERNALS
#	do
#	    if [ "$X" != "$IPFX" -a -f $X$Y.pl ] ; then
	    if [ "$X" != "$IPFX" ] ; then
#		echo "\\internal[$Y]{$X}"
		echo "\\internal{$X}"
	    fi
#	done
    done

    cat <<EOF

\\startdocument
%% \\begin{document}
%% \\${LEVEL}{${SUBJ}}

EOF

    cat $FNAME
) > $IPFX.tex

eval $TEXENV
set -x
$L2H $L2HCOMMON -prefix $IPFX -t "$SUBJ" $IPFX.tex
#rm -f $IPFX.tex
