/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/* NOTE: This can't co-exist with ndbm! */

/* LINTLIBRARY */

#include "mailer.h"
#ifdef	USE_DBM

#ifdef	NULL
#undef	NULL
#endif	/* NULL */
#ifdef	NeXT
#define	__STRICT_BSD__
#endif	/* NeXT */
#include <dbm.h>
#ifdef	NeXT
#undef	__STRICT_BSD__
#endif	/* NeXT */
#ifdef	NULL
#undef	NULL
#endif	/* NULL */
#define	NULL	0
#include "search.h"
#include "io.h"


static int inited = 0;

extern int dbminit();
extern int deferit;
extern int delete();
extern int store();
extern void dbmclose();
extern void v_set();


int
open_dbm(sip, comment)
	struct search_info *sip;
	char *comment;
{
	if (sip->file == NULL)
		return NULL;
	if (inited == 0 && dbminit(sip->file) < 0) {
		++deferit;
		v_set(DEFER, DEFER_IO_ERROR);
		fprintf(stderr, "%s: cannot open %s!\n", comment, sip->file);
		return -1;
	}
	inited = 1;
	return 0;
}

/*
 * Search a DBM format database for a key pair.
 */

struct conscell *
search_dbm(sip)
	struct search_info *sip;
{
	struct conscell *tmp;
	datum val, key;

	if (open_dbm(sip, "search_dbm") < 0)
		return NULL;
	key.dptr = (char *)(sip->key);
	key.dsize = strlen((char *)(sip->key)) + 1;
	val = fetch(key);
	if (val.dptr == NULL)
		return NULL;
	return newstring((u_char *)strnsave(val.dptr, val.dsize));
}

/*
 * Flush buffered information from this database, close any file descriptors.
 */

void
close_dbm(sip)
	struct search_info *sip;
{
	if (sip->file == NULL)
		return;
	if (inited == 0)
		return;
#ifdef	USE_DBMCLOSE
	dbmclose();
#endif	/* USE_DBMCLOSE */
	inited = 0;
}

/*
 * Add the indicated key/value pair to the database.
 */

int
add_dbm(sip, value)
	struct search_info *sip;
	char *value;
{
	datum val, key;

	if (open_dbm(sip, "add_dbm") < 0)
		return EOF;
	key.dptr = (char *)(sip->key);
	key.dsize = strlen((char *)(sip->key)) + 1;
	val.dptr = value;
	val.dsize = strlen(value)+1;
	if (store(key, val) < 0) {
		++deferit;
		v_set(DEFER, DEFER_IO_ERROR);
		fprintf(stderr, "add_dbm: cannot store (\"%s\",\"%s\")\n",
				sip->key, value);
		return EOF;
	}
	return 0;
}

/*
 * Remove the indicated key from the database.
 */

int
remove_dbm(sip)
	struct search_info *sip;
{
	datum key;

	if (open_dbm(sip, "remove_dbm") < 0)
		return EOF;
	key.dptr = (char *)(sip->key);
	key.dsize = strlen((char *)(sip->key)) + 1;
	if (delete(key) < 0) {
		++deferit;
		v_set(DEFER, DEFER_IO_ERROR);
		fprintf(stderr, "remove_dbm: cannot remove \"%s\"\n", sip->key);
		return EOF;
	}
	return 0;
}

/*
 * Print the database.
 */

void
print_dbm(sip, outfp)
	struct search_info *sip;
	FILE *outfp;
{
	datum key, val;

	if (open_dbm(sip, "print_dbm") < 0)
		return;
	for (key = firstkey(); key.dptr != NULL; key = nextkey(key)) {
		val = fetch(key);
		if (val.dptr == NULL)
			continue;
		if (*val.dptr == '\0')
			fprintf(outfp, "%s\n", key.dptr);
		else
			fprintf(outfp, "%s\t%s\n", key.dptr, val.dptr);
	}
	fflush(outfp);
}

/*
 * Print the uid of the owner of the database.  Note that for dbm-style
 * databases there are several files involved so picking one of them for
 * security purposes is very dubious.
 */

void
owner_dbm(sip, outfp)
	struct search_info *sip;
	FILE *outfp;
{
	struct stat stbuf;

	if (sip->file == NULL) {
		fprintf(stderr, "owner_dbm: no file specified!\n");
		return;
	}
	if (stat(sip->file, &stbuf) < 0) {
		fprintf(stderr, "owner_dbm: cannot stat \"%s\"!\n", sip->file);
		return;
	}
	fprintf(outfp, "%d\n", stbuf.st_uid);
	fflush(outfp);
}
#endif	/* USE_DBM */
