/* 
 *  Malloc definitions from General Utilities <stdlib.h>. Note that we
 *  disagree with Berkeley Unix on the return type of free/cfree.
 */
extern univptr_t malloc proto((size_t));
extern univptr_t calloc proto((size_t, size_t));
extern univptr_t realloc proto((univptr_t, size_t));
extern void free proto((univptr_t));

/* Malloc definitions - my additions */
extern univptr_t emalloc proto((size_t));
extern univptr_t erealloc proto((univptr_t, size_t));
extern char *strdup proto((const char *));
extern char *strsave proto((const char *));
extern void mal_contents proto((FILE *));
extern void mal_debug proto((int));
extern void mal_dumpleaktrace proto((FILE *));
extern void mal_heapdump proto((FILE *));
extern void mal_leaktrace proto((int));
extern void mal_sbrkset proto((int));
extern void mal_slopset proto((int));
extern void mal_statsdump proto(());
extern void mal_setstatsfile proto((FILE *));
extern void mal_trace proto((int));
extern int mal_verify proto((int));

/* Backwards compatibility - one of these days, this is going to go */
extern univptr_t valloc proto((size_t));
extern univptr_t memalign proto((size_t, size_t));
extern void cfree proto((univptr_t));

/* Internal definitions */
extern int __nothing proto((void));

/* General Utilities <stdlib.h> */

extern void	abort proto((void));
extern void	exit proto((int));

/*
 *  Input/Output <stdio.h> Note we disagree with Berkeley Unix on
 *  sprintf().
 */

#if defined(sun) || defined(__sun__)
/*extern int sprintf proto((char *, const char *, ...));*/
#endif

extern int fputs proto((const char *, FILE *));
extern int fflush proto((FILE *));
extern int setvbuf proto((FILE *, char *, int, memsize_t));

/* Character Handling: <string.h> */

extern univptr_t memset proto((univptr_t, int, memsize_t));
extern univptr_t memcpy proto((univptr_t, const univptr_t, memsize_t));
extern char *strcpy proto((char *, const char *));
extern memsize_t strlen proto((const char *));

/* UNIX */
extern int getpagesize proto((void));
extern caddr_t sbrk proto((int));
extern int write proto((int, const char *, int));
