/*  This file should be edited with 4-column tabs! */
/*  Author: Mark Moraes <moraes@csri.toronto.edu> */

/*LINTLIBRARY*/

#include "defs.h"
#include "globals.h"

RCSID("$Header: /j/moraes/shmem/malloc/malloc/RCS/setdebug.c,v 1.7 89/10/31 02:01:54 moraes Exp $");

/* 
 *  Sets debugging level - level 0 and 1 both perform normal checking -
 *  making sure a pointer is valid before it is used for any heap data,
 *  and doing consistency checking on any block it touches while it
 *  works. Level 2 asks for a mal_verify() on every malloc(), free() or
 *  realloc(), thus checking the entire heap's pointers for consistency.
 *  Level 3 makes mal_verify() check that all free blocks contain a
 *  magic pattern that is put into a free block when it is freed.
 */
void
mal_debug(level)
int level;
{
#ifdef DEBUG
	if (level < 0 || level > 3) {
		return;
	}
	_malloc_debugging = level;
#endif /* DEBUG */
}
